/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.ValidationMessage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectivityValidation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalMessageCount")
    private final Integer totalMessageCount;
    @JsonProperty(value="errorMessageCount")
    private final Integer errorMessageCount;
    @JsonProperty(value="warnMessageCount")
    private final Integer warnMessageCount;
    @JsonProperty(value="infoMessageCount")
    private final Integer infoMessageCount;
    @JsonProperty(value="validationMessages")
    private final Map<String, List<ValidationMessage>> validationMessages;

    @Deprecated
    @ConstructorProperties(value={"totalMessageCount", "errorMessageCount", "warnMessageCount", "infoMessageCount", "validationMessages"})
    public ConnectivityValidation(Integer totalMessageCount, Integer errorMessageCount, Integer warnMessageCount, Integer infoMessageCount, Map<String, List<ValidationMessage>> validationMessages) {
        this.totalMessageCount = totalMessageCount;
        this.errorMessageCount = errorMessageCount;
        this.warnMessageCount = warnMessageCount;
        this.infoMessageCount = infoMessageCount;
        this.validationMessages = validationMessages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public Integer getErrorMessageCount() {
        return this.errorMessageCount;
    }

    public Integer getWarnMessageCount() {
        return this.warnMessageCount;
    }

    public Integer getInfoMessageCount() {
        return this.infoMessageCount;
    }

    public Map<String, List<ValidationMessage>> getValidationMessages() {
        return this.validationMessages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectivityValidation(");
        sb.append("super=").append(super.toString());
        sb.append("totalMessageCount=").append(String.valueOf(this.totalMessageCount));
        sb.append(", errorMessageCount=").append(String.valueOf(this.errorMessageCount));
        sb.append(", warnMessageCount=").append(String.valueOf(this.warnMessageCount));
        sb.append(", infoMessageCount=").append(String.valueOf(this.infoMessageCount));
        sb.append(", validationMessages=").append(String.valueOf(this.validationMessages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectivityValidation)) {
            return false;
        }
        ConnectivityValidation other = (ConnectivityValidation)((Object)o);
        return Objects.equals(this.totalMessageCount, other.totalMessageCount) && Objects.equals(this.errorMessageCount, other.errorMessageCount) && Objects.equals(this.warnMessageCount, other.warnMessageCount) && Objects.equals(this.infoMessageCount, other.infoMessageCount) && Objects.equals(this.validationMessages, other.validationMessages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalMessageCount == null ? 43 : this.totalMessageCount.hashCode());
        result = result * 59 + (this.errorMessageCount == null ? 43 : this.errorMessageCount.hashCode());
        result = result * 59 + (this.warnMessageCount == null ? 43 : this.warnMessageCount.hashCode());
        result = result * 59 + (this.infoMessageCount == null ? 43 : this.infoMessageCount.hashCode());
        result = result * 59 + (this.validationMessages == null ? 43 : this.validationMessages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalMessageCount")
        private Integer totalMessageCount;
        @JsonProperty(value="errorMessageCount")
        private Integer errorMessageCount;
        @JsonProperty(value="warnMessageCount")
        private Integer warnMessageCount;
        @JsonProperty(value="infoMessageCount")
        private Integer infoMessageCount;
        @JsonProperty(value="validationMessages")
        private Map<String, List<ValidationMessage>> validationMessages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalMessageCount(Integer totalMessageCount) {
            this.totalMessageCount = totalMessageCount;
            this.__explicitlySet__.add("totalMessageCount");
            return this;
        }

        public Builder errorMessageCount(Integer errorMessageCount) {
            this.errorMessageCount = errorMessageCount;
            this.__explicitlySet__.add("errorMessageCount");
            return this;
        }

        public Builder warnMessageCount(Integer warnMessageCount) {
            this.warnMessageCount = warnMessageCount;
            this.__explicitlySet__.add("warnMessageCount");
            return this;
        }

        public Builder infoMessageCount(Integer infoMessageCount) {
            this.infoMessageCount = infoMessageCount;
            this.__explicitlySet__.add("infoMessageCount");
            return this;
        }

        public Builder validationMessages(Map<String, List<ValidationMessage>> validationMessages) {
            this.validationMessages = validationMessages;
            this.__explicitlySet__.add("validationMessages");
            return this;
        }

        public ConnectivityValidation build() {
            ConnectivityValidation model = new ConnectivityValidation(this.totalMessageCount, this.errorMessageCount, this.warnMessageCount, this.infoMessageCount, this.validationMessages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectivityValidation model) {
            if (model.wasPropertyExplicitlySet("totalMessageCount")) {
                this.totalMessageCount(model.getTotalMessageCount());
            }
            if (model.wasPropertyExplicitlySet("errorMessageCount")) {
                this.errorMessageCount(model.getErrorMessageCount());
            }
            if (model.wasPropertyExplicitlySet("warnMessageCount")) {
                this.warnMessageCount(model.getWarnMessageCount());
            }
            if (model.wasPropertyExplicitlySet("infoMessageCount")) {
                this.infoMessageCount(model.getInfoMessageCount());
            }
            if (model.wasPropertyExplicitlySet("validationMessages")) {
                this.validationMessages(model.getValidationMessages());
            }
            return this;
        }
    }
}

