/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.BaseType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigParameterDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="parameterType")
    private final BaseType parameterType;
    @JsonProperty(value="parameterName")
    private final String parameterName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="defaultValue")
    private final Object defaultValue;
    @JsonProperty(value="classFieldName")
    private final String classFieldName;
    @JsonProperty(value="isStatic")
    private final Boolean isStatic;
    @JsonProperty(value="isClassFieldValue")
    private final Boolean isClassFieldValue;

    @Deprecated
    @ConstructorProperties(value={"parameterType", "parameterName", "description", "defaultValue", "classFieldName", "isStatic", "isClassFieldValue"})
    public ConfigParameterDefinition(BaseType parameterType, String parameterName, String description, Object defaultValue, String classFieldName, Boolean isStatic, Boolean isClassFieldValue) {
        this.parameterType = parameterType;
        this.parameterName = parameterName;
        this.description = description;
        this.defaultValue = defaultValue;
        this.classFieldName = classFieldName;
        this.isStatic = isStatic;
        this.isClassFieldValue = isClassFieldValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BaseType getParameterType() {
        return this.parameterType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getClassFieldName() {
        return this.classFieldName;
    }

    public Boolean getIsStatic() {
        return this.isStatic;
    }

    public Boolean getIsClassFieldValue() {
        return this.isClassFieldValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigParameterDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("parameterType=").append(String.valueOf((Object)this.parameterType));
        sb.append(", parameterName=").append(String.valueOf(this.parameterName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", classFieldName=").append(String.valueOf(this.classFieldName));
        sb.append(", isStatic=").append(String.valueOf(this.isStatic));
        sb.append(", isClassFieldValue=").append(String.valueOf(this.isClassFieldValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigParameterDefinition)) {
            return false;
        }
        ConfigParameterDefinition other = (ConfigParameterDefinition)((Object)o);
        return Objects.equals((Object)this.parameterType, (Object)other.parameterType) && Objects.equals(this.parameterName, other.parameterName) && Objects.equals(this.description, other.description) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.classFieldName, other.classFieldName) && Objects.equals(this.isStatic, other.isStatic) && Objects.equals(this.isClassFieldValue, other.isClassFieldValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.parameterType == null ? 43 : this.parameterType.hashCode());
        result = result * 59 + (this.parameterName == null ? 43 : this.parameterName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.classFieldName == null ? 43 : this.classFieldName.hashCode());
        result = result * 59 + (this.isStatic == null ? 43 : this.isStatic.hashCode());
        result = result * 59 + (this.isClassFieldValue == null ? 43 : this.isClassFieldValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parameterType")
        private BaseType parameterType;
        @JsonProperty(value="parameterName")
        private String parameterName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="defaultValue")
        private Object defaultValue;
        @JsonProperty(value="classFieldName")
        private String classFieldName;
        @JsonProperty(value="isStatic")
        private Boolean isStatic;
        @JsonProperty(value="isClassFieldValue")
        private Boolean isClassFieldValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parameterType(BaseType parameterType) {
            this.parameterType = parameterType;
            this.__explicitlySet__.add("parameterType");
            return this;
        }

        public Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            this.__explicitlySet__.add("parameterName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder classFieldName(String classFieldName) {
            this.classFieldName = classFieldName;
            this.__explicitlySet__.add("classFieldName");
            return this;
        }

        public Builder isStatic(Boolean isStatic) {
            this.isStatic = isStatic;
            this.__explicitlySet__.add("isStatic");
            return this;
        }

        public Builder isClassFieldValue(Boolean isClassFieldValue) {
            this.isClassFieldValue = isClassFieldValue;
            this.__explicitlySet__.add("isClassFieldValue");
            return this;
        }

        public ConfigParameterDefinition build() {
            ConfigParameterDefinition model = new ConfigParameterDefinition(this.parameterType, this.parameterName, this.description, this.defaultValue, this.classFieldName, this.isStatic, this.isClassFieldValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigParameterDefinition model) {
            if (model.wasPropertyExplicitlySet("parameterType")) {
                this.parameterType(model.getParameterType());
            }
            if (model.wasPropertyExplicitlySet("parameterName")) {
                this.parameterName(model.getParameterName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("classFieldName")) {
                this.classFieldName(model.getClassFieldName());
            }
            if (model.wasPropertyExplicitlySet("isStatic")) {
                this.isStatic(model.getIsStatic());
            }
            if (model.wasPropertyExplicitlySet("isClassFieldValue")) {
                this.isClassFieldValue(model.getIsClassFieldValue());
            }
            return this;
        }
    }
}

