/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AbstractReadAttribute;
import com.oracle.bmc.dataconnectivity.model.ExternalStorage;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class BiccReadAttributes
extends AbstractReadAttribute {
    @JsonProperty(value="fetchSize")
    private final Integer fetchSize;
    @JsonProperty(value="extractStrategy")
    private final ExtractStrategy extractStrategy;
    @JsonProperty(value="externalStorage")
    private final ExternalStorage externalStorage;
    @JsonProperty(value="initialExtractDate")
    private final Date initialExtractDate;
    @JsonProperty(value="lastExtractDate")
    private final Date lastExtractDate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BiccReadAttributes(Integer fetchSize, ExtractStrategy extractStrategy, ExternalStorage externalStorage, Date initialExtractDate, Date lastExtractDate) {
        this.fetchSize = fetchSize;
        this.extractStrategy = extractStrategy;
        this.externalStorage = externalStorage;
        this.initialExtractDate = initialExtractDate;
        this.lastExtractDate = lastExtractDate;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public ExtractStrategy getExtractStrategy() {
        return this.extractStrategy;
    }

    public ExternalStorage getExternalStorage() {
        return this.externalStorage;
    }

    public Date getInitialExtractDate() {
        return this.initialExtractDate;
    }

    public Date getLastExtractDate() {
        return this.lastExtractDate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BiccReadAttributes(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fetchSize=").append(String.valueOf(this.fetchSize));
        sb.append(", extractStrategy=").append(String.valueOf((Object)this.extractStrategy));
        sb.append(", externalStorage=").append(String.valueOf((Object)this.externalStorage));
        sb.append(", initialExtractDate=").append(String.valueOf(this.initialExtractDate));
        sb.append(", lastExtractDate=").append(String.valueOf(this.lastExtractDate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BiccReadAttributes)) {
            return false;
        }
        BiccReadAttributes other = (BiccReadAttributes)((Object)o);
        return Objects.equals(this.fetchSize, other.fetchSize) && Objects.equals((Object)this.extractStrategy, (Object)other.extractStrategy) && Objects.equals((Object)this.externalStorage, (Object)other.externalStorage) && Objects.equals(this.initialExtractDate, other.initialExtractDate) && Objects.equals(this.lastExtractDate, other.lastExtractDate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fetchSize == null ? 43 : this.fetchSize.hashCode());
        result = result * 59 + (this.extractStrategy == null ? 43 : this.extractStrategy.hashCode());
        result = result * 59 + (this.externalStorage == null ? 43 : this.externalStorage.hashCode());
        result = result * 59 + (this.initialExtractDate == null ? 43 : this.initialExtractDate.hashCode());
        result = result * 59 + (this.lastExtractDate == null ? 43 : this.lastExtractDate.hashCode());
        return result;
    }

    public static enum ExtractStrategy implements BmcEnum
    {
        Full("FULL"),
        Incremental("INCREMENTAL");

        private final String value;
        private static Map<String, ExtractStrategy> map;

        private ExtractStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExtractStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ExtractStrategy: " + key);
        }

        static {
            map = new HashMap<String, ExtractStrategy>();
            for (ExtractStrategy v : ExtractStrategy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fetchSize")
        private Integer fetchSize;
        @JsonProperty(value="extractStrategy")
        private ExtractStrategy extractStrategy;
        @JsonProperty(value="externalStorage")
        private ExternalStorage externalStorage;
        @JsonProperty(value="initialExtractDate")
        private Date initialExtractDate;
        @JsonProperty(value="lastExtractDate")
        private Date lastExtractDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            this.__explicitlySet__.add("fetchSize");
            return this;
        }

        public Builder extractStrategy(ExtractStrategy extractStrategy) {
            this.extractStrategy = extractStrategy;
            this.__explicitlySet__.add("extractStrategy");
            return this;
        }

        public Builder externalStorage(ExternalStorage externalStorage) {
            this.externalStorage = externalStorage;
            this.__explicitlySet__.add("externalStorage");
            return this;
        }

        public Builder initialExtractDate(Date initialExtractDate) {
            this.initialExtractDate = initialExtractDate;
            this.__explicitlySet__.add("initialExtractDate");
            return this;
        }

        public Builder lastExtractDate(Date lastExtractDate) {
            this.lastExtractDate = lastExtractDate;
            this.__explicitlySet__.add("lastExtractDate");
            return this;
        }

        public BiccReadAttributes build() {
            BiccReadAttributes model = new BiccReadAttributes(this.fetchSize, this.extractStrategy, this.externalStorage, this.initialExtractDate, this.lastExtractDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BiccReadAttributes model) {
            if (model.wasPropertyExplicitlySet("fetchSize")) {
                this.fetchSize(model.getFetchSize());
            }
            if (model.wasPropertyExplicitlySet("extractStrategy")) {
                this.extractStrategy(model.getExtractStrategy());
            }
            if (model.wasPropertyExplicitlySet("externalStorage")) {
                this.externalStorage(model.getExternalStorage());
            }
            if (model.wasPropertyExplicitlySet("initialExtractDate")) {
                this.initialExtractDate(model.getInitialExtractDate());
            }
            if (model.wasPropertyExplicitlySet("lastExtractDate")) {
                this.lastExtractDate(model.getLastExtractDate());
            }
            return this;
        }
    }
}

