/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity;

import com.oracle.bmc.dataconnectivity.DataConnectivityManagement;
import com.oracle.bmc.dataconnectivity.model.Endpoint;
import com.oracle.bmc.dataconnectivity.model.Registry;
import com.oracle.bmc.dataconnectivity.requests.GetEndpointRequest;
import com.oracle.bmc.dataconnectivity.requests.GetRegistryRequest;
import com.oracle.bmc.dataconnectivity.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataconnectivity.responses.GetEndpointResponse;
import com.oracle.bmc.dataconnectivity.responses.GetRegistryResponse;
import com.oracle.bmc.dataconnectivity.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataConnectivityManagementWaiters {
    private final ExecutorService executorService;
    private final DataConnectivityManagement client;

    public DataConnectivityManagementWaiters(ExecutorService executorService, DataConnectivityManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(BmcGenericWaiter waiter, GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        final HashSet<Endpoint.LifecycleState> targetStatesSet = new HashSet<Endpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEndpointRequest, GetEndpointResponse>(){

            @Override
            public GetEndpointResponse apply(GetEndpointRequest request) {
                return DataConnectivityManagementWaiters.this.client.getEndpoint(request);
            }
        }, (Predicate)new Predicate<GetEndpointResponse>(){

            @Override
            public boolean test(GetEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Endpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRegistryRequest, GetRegistryResponse> forRegistry(GetRegistryRequest request, Registry.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRegistry(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRegistryRequest, GetRegistryResponse> forRegistry(GetRegistryRequest request, Registry.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRegistry(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRegistryRequest, GetRegistryResponse> forRegistry(GetRegistryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Registry.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRegistry(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRegistryRequest, GetRegistryResponse> forRegistry(BmcGenericWaiter waiter, GetRegistryRequest request, Registry.LifecycleState ... targetStates) {
        final HashSet<Registry.LifecycleState> targetStatesSet = new HashSet<Registry.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRegistryRequest, GetRegistryResponse>(){

            @Override
            public GetRegistryResponse apply(GetRegistryRequest request) {
                return DataConnectivityManagementWaiters.this.client.getRegistry(request);
            }
        }, (Predicate)new Predicate<GetRegistryResponse>(){

            @Override
            public boolean test(GetRegistryResponse response) {
                return targetStatesSet.contains((Object)response.getRegistry().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Registry.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataConnectivityManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

