/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity;

import com.oracle.bmc.dataconnectivity.DataConnectivityManagement;
import com.oracle.bmc.dataconnectivity.model.ConnectionSummary;
import com.oracle.bmc.dataconnectivity.model.DataAssetSummary;
import com.oracle.bmc.dataconnectivity.model.DataEntitySummary;
import com.oracle.bmc.dataconnectivity.model.EndpointSummary;
import com.oracle.bmc.dataconnectivity.model.FolderSummary;
import com.oracle.bmc.dataconnectivity.model.OperationSummary;
import com.oracle.bmc.dataconnectivity.model.ReferenceArtifactSummary;
import com.oracle.bmc.dataconnectivity.model.RegistrySummary;
import com.oracle.bmc.dataconnectivity.model.SchemaSummary;
import com.oracle.bmc.dataconnectivity.model.TypeSummary;
import com.oracle.bmc.dataconnectivity.model.WorkRequestError;
import com.oracle.bmc.dataconnectivity.model.WorkRequestLog;
import com.oracle.bmc.dataconnectivity.model.WorkRequestSummary;
import com.oracle.bmc.dataconnectivity.requests.ListConnectionsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListEndpointsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListFoldersRequest;
import com.oracle.bmc.dataconnectivity.requests.ListOperationsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListReferenceArtifactsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListRegistriesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListSchemasRequest;
import com.oracle.bmc.dataconnectivity.requests.ListTypesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataconnectivity.responses.ListConnectionsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListEndpointsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListFoldersResponse;
import com.oracle.bmc.dataconnectivity.responses.ListOperationsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListReferenceArtifactsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListRegistriesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListSchemasResponse;
import com.oracle.bmc.dataconnectivity.responses.ListTypesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataConnectivityManagementPaginators {
    private final DataConnectivityManagement client;

    public DataConnectivityManagementPaginators(DataConnectivityManagement client) {
        this.client = client;
    }

    public Iterable<ListConnectionsResponse> listConnectionsResponseIterator(final ListConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listConnections(request);
            }
        });
    }

    public Iterable<ConnectionSummary> listConnectionsRecordIterator(final ListConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listConnections(request);
            }
        }, (Function)new Function<ListConnectionsResponse, List<ConnectionSummary>>(){

            @Override
            public List<ConnectionSummary> apply(ListConnectionsResponse response) {
                return response.getConnectionSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataAssetsResponse> listDataAssetsResponseIterator(final ListDataAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            @Override
            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            @Override
            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            @Override
            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            @Override
            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listDataAssets(request);
            }
        });
    }

    public Iterable<DataAssetSummary> listDataAssetsRecordIterator(final ListDataAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            @Override
            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            @Override
            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            @Override
            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            @Override
            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listDataAssets(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, List<DataAssetSummary>>(){

            @Override
            public List<DataAssetSummary> apply(ListDataAssetsResponse response) {
                return response.getDataAssetSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataEntitiesResponse> listDataEntitiesResponseIterator(final ListDataEntitiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataEntitiesRequest.Builder>(){

            @Override
            public ListDataEntitiesRequest.Builder get() {
                return ListDataEntitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, String>(){

            @Override
            public String apply(ListDataEntitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataEntitiesRequest.Builder>, ListDataEntitiesRequest>(){

            @Override
            public ListDataEntitiesRequest apply(RequestBuilderAndToken<ListDataEntitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataEntitiesRequest, ListDataEntitiesResponse>(){

            @Override
            public ListDataEntitiesResponse apply(ListDataEntitiesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listDataEntities(request);
            }
        });
    }

    public Iterable<DataEntitySummary> listDataEntitiesRecordIterator(final ListDataEntitiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataEntitiesRequest.Builder>(){

            @Override
            public ListDataEntitiesRequest.Builder get() {
                return ListDataEntitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, String>(){

            @Override
            public String apply(ListDataEntitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataEntitiesRequest.Builder>, ListDataEntitiesRequest>(){

            @Override
            public ListDataEntitiesRequest apply(RequestBuilderAndToken<ListDataEntitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataEntitiesRequest, ListDataEntitiesResponse>(){

            @Override
            public ListDataEntitiesResponse apply(ListDataEntitiesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listDataEntities(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, List<DataEntitySummary>>(){

            @Override
            public List<DataEntitySummary> apply(ListDataEntitiesResponse response) {
                return response.getDataEntitySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListEndpointsResponse> listEndpointsResponseIterator(final ListEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listEndpoints(request);
            }
        });
    }

    public Iterable<EndpointSummary> listEndpointsRecordIterator(final ListEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listEndpoints(request);
            }
        }, (Function)new Function<ListEndpointsResponse, List<EndpointSummary>>(){

            @Override
            public List<EndpointSummary> apply(ListEndpointsResponse response) {
                return response.getEndpointSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListFoldersResponse> listFoldersResponseIterator(final ListFoldersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFoldersRequest.Builder>(){

            @Override
            public ListFoldersRequest.Builder get() {
                return ListFoldersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFoldersResponse, String>(){

            @Override
            public String apply(ListFoldersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFoldersRequest.Builder>, ListFoldersRequest>(){

            @Override
            public ListFoldersRequest apply(RequestBuilderAndToken<ListFoldersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFoldersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFoldersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFoldersRequest, ListFoldersResponse>(){

            @Override
            public ListFoldersResponse apply(ListFoldersRequest request) {
                return DataConnectivityManagementPaginators.this.client.listFolders(request);
            }
        });
    }

    public Iterable<FolderSummary> listFoldersRecordIterator(final ListFoldersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFoldersRequest.Builder>(){

            @Override
            public ListFoldersRequest.Builder get() {
                return ListFoldersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFoldersResponse, String>(){

            @Override
            public String apply(ListFoldersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFoldersRequest.Builder>, ListFoldersRequest>(){

            @Override
            public ListFoldersRequest apply(RequestBuilderAndToken<ListFoldersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFoldersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFoldersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFoldersRequest, ListFoldersResponse>(){

            @Override
            public ListFoldersResponse apply(ListFoldersRequest request) {
                return DataConnectivityManagementPaginators.this.client.listFolders(request);
            }
        }, (Function)new Function<ListFoldersResponse, List<FolderSummary>>(){

            @Override
            public List<FolderSummary> apply(ListFoldersResponse response) {
                return response.getFolderSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListOperationsResponse> listOperationsResponseIterator(final ListOperationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOperationsRequest.Builder>(){

            @Override
            public ListOperationsRequest.Builder get() {
                return ListOperationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperationsResponse, String>(){

            @Override
            public String apply(ListOperationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperationsRequest.Builder>, ListOperationsRequest>(){

            @Override
            public ListOperationsRequest apply(RequestBuilderAndToken<ListOperationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperationsRequest, ListOperationsResponse>(){

            @Override
            public ListOperationsResponse apply(ListOperationsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listOperations(request);
            }
        });
    }

    public Iterable<OperationSummary> listOperationsRecordIterator(final ListOperationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOperationsRequest.Builder>(){

            @Override
            public ListOperationsRequest.Builder get() {
                return ListOperationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperationsResponse, String>(){

            @Override
            public String apply(ListOperationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperationsRequest.Builder>, ListOperationsRequest>(){

            @Override
            public ListOperationsRequest apply(RequestBuilderAndToken<ListOperationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperationsRequest, ListOperationsResponse>(){

            @Override
            public ListOperationsResponse apply(ListOperationsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listOperations(request);
            }
        }, (Function)new Function<ListOperationsResponse, List<OperationSummary>>(){

            @Override
            public List<OperationSummary> apply(ListOperationsResponse response) {
                return response.getOperationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListReferenceArtifactsResponse> listReferenceArtifactsResponseIterator(final ListReferenceArtifactsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReferenceArtifactsRequest.Builder>(){

            @Override
            public ListReferenceArtifactsRequest.Builder get() {
                return ListReferenceArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReferenceArtifactsResponse, String>(){

            @Override
            public String apply(ListReferenceArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReferenceArtifactsRequest.Builder>, ListReferenceArtifactsRequest>(){

            @Override
            public ListReferenceArtifactsRequest apply(RequestBuilderAndToken<ListReferenceArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReferenceArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReferenceArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReferenceArtifactsRequest, ListReferenceArtifactsResponse>(){

            @Override
            public ListReferenceArtifactsResponse apply(ListReferenceArtifactsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listReferenceArtifacts(request);
            }
        });
    }

    public Iterable<ReferenceArtifactSummary> listReferenceArtifactsRecordIterator(final ListReferenceArtifactsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReferenceArtifactsRequest.Builder>(){

            @Override
            public ListReferenceArtifactsRequest.Builder get() {
                return ListReferenceArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReferenceArtifactsResponse, String>(){

            @Override
            public String apply(ListReferenceArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReferenceArtifactsRequest.Builder>, ListReferenceArtifactsRequest>(){

            @Override
            public ListReferenceArtifactsRequest apply(RequestBuilderAndToken<ListReferenceArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReferenceArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReferenceArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReferenceArtifactsRequest, ListReferenceArtifactsResponse>(){

            @Override
            public ListReferenceArtifactsResponse apply(ListReferenceArtifactsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listReferenceArtifacts(request);
            }
        }, (Function)new Function<ListReferenceArtifactsResponse, List<ReferenceArtifactSummary>>(){

            @Override
            public List<ReferenceArtifactSummary> apply(ListReferenceArtifactsResponse response) {
                return response.getReferenceArtifactSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListRegistriesResponse> listRegistriesResponseIterator(final ListRegistriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRegistriesRequest.Builder>(){

            @Override
            public ListRegistriesRequest.Builder get() {
                return ListRegistriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRegistriesResponse, String>(){

            @Override
            public String apply(ListRegistriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRegistriesRequest.Builder>, ListRegistriesRequest>(){

            @Override
            public ListRegistriesRequest apply(RequestBuilderAndToken<ListRegistriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRegistriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRegistriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRegistriesRequest, ListRegistriesResponse>(){

            @Override
            public ListRegistriesResponse apply(ListRegistriesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listRegistries(request);
            }
        });
    }

    public Iterable<RegistrySummary> listRegistriesRecordIterator(final ListRegistriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRegistriesRequest.Builder>(){

            @Override
            public ListRegistriesRequest.Builder get() {
                return ListRegistriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRegistriesResponse, String>(){

            @Override
            public String apply(ListRegistriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRegistriesRequest.Builder>, ListRegistriesRequest>(){

            @Override
            public ListRegistriesRequest apply(RequestBuilderAndToken<ListRegistriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRegistriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRegistriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRegistriesRequest, ListRegistriesResponse>(){

            @Override
            public ListRegistriesResponse apply(ListRegistriesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listRegistries(request);
            }
        }, (Function)new Function<ListRegistriesResponse, List<RegistrySummary>>(){

            @Override
            public List<RegistrySummary> apply(ListRegistriesResponse response) {
                return response.getRegistrySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListSchemasResponse> listSchemasResponseIterator(final ListSchemasRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchemasRequest.Builder>(){

            @Override
            public ListSchemasRequest.Builder get() {
                return ListSchemasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchemasResponse, String>(){

            @Override
            public String apply(ListSchemasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchemasRequest.Builder>, ListSchemasRequest>(){

            @Override
            public ListSchemasRequest apply(RequestBuilderAndToken<ListSchemasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchemasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchemasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchemasRequest, ListSchemasResponse>(){

            @Override
            public ListSchemasResponse apply(ListSchemasRequest request) {
                return DataConnectivityManagementPaginators.this.client.listSchemas(request);
            }
        });
    }

    public Iterable<SchemaSummary> listSchemasRecordIterator(final ListSchemasRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchemasRequest.Builder>(){

            @Override
            public ListSchemasRequest.Builder get() {
                return ListSchemasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchemasResponse, String>(){

            @Override
            public String apply(ListSchemasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchemasRequest.Builder>, ListSchemasRequest>(){

            @Override
            public ListSchemasRequest apply(RequestBuilderAndToken<ListSchemasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchemasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchemasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchemasRequest, ListSchemasResponse>(){

            @Override
            public ListSchemasResponse apply(ListSchemasRequest request) {
                return DataConnectivityManagementPaginators.this.client.listSchemas(request);
            }
        }, (Function)new Function<ListSchemasResponse, List<SchemaSummary>>(){

            @Override
            public List<SchemaSummary> apply(ListSchemasResponse response) {
                return response.getSchemaSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListTypesResponse> listTypesResponseIterator(final ListTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTypesRequest.Builder>(){

            @Override
            public ListTypesRequest.Builder get() {
                return ListTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTypesResponse, String>(){

            @Override
            public String apply(ListTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTypesRequest.Builder>, ListTypesRequest>(){

            @Override
            public ListTypesRequest apply(RequestBuilderAndToken<ListTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTypesRequest, ListTypesResponse>(){

            @Override
            public ListTypesResponse apply(ListTypesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listTypes(request);
            }
        });
    }

    public Iterable<TypeSummary> listTypesRecordIterator(final ListTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTypesRequest.Builder>(){

            @Override
            public ListTypesRequest.Builder get() {
                return ListTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTypesResponse, String>(){

            @Override
            public String apply(ListTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTypesRequest.Builder>, ListTypesRequest>(){

            @Override
            public ListTypesRequest apply(RequestBuilderAndToken<ListTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTypesRequest, ListTypesResponse>(){

            @Override
            public ListTypesResponse apply(ListTypesRequest request) {
                return DataConnectivityManagementPaginators.this.client.listTypes(request);
            }
        }, (Function)new Function<ListTypesResponse, List<TypeSummary>>(){

            @Override
            public List<TypeSummary> apply(ListTypesResponse response) {
                return response.getTypesSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            @Override
            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataConnectivityManagementPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

