/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ValidatePatternDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidatePatternRequest
extends BmcRequest<ValidatePatternDetails> {
    private String catalogId;
    private String patternKey;
    private ValidatePatternDetails validatePatternDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getPatternKey() {
        return this.patternKey;
    }

    public ValidatePatternDetails getValidatePatternDetails() {
        return this.validatePatternDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ValidatePatternDetails getBody$() {
        return this.validatePatternDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).patternKey(this.patternKey).validatePatternDetails(this.validatePatternDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",patternKey=").append(String.valueOf(this.patternKey));
        sb.append(",validatePatternDetails=").append(String.valueOf((Object)this.validatePatternDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidatePatternRequest)) {
            return false;
        }
        ValidatePatternRequest other = (ValidatePatternRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.patternKey, other.patternKey) && Objects.equals((Object)this.validatePatternDetails, (Object)other.validatePatternDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.patternKey == null ? 43 : this.patternKey.hashCode());
        result = result * 59 + (this.validatePatternDetails == null ? 43 : this.validatePatternDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidatePatternRequest, ValidatePatternDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String patternKey = null;
        private ValidatePatternDetails validatePatternDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder patternKey(String patternKey) {
            this.patternKey = patternKey;
            return this;
        }

        public Builder validatePatternDetails(ValidatePatternDetails validatePatternDetails) {
            this.validatePatternDetails = validatePatternDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidatePatternRequest o) {
            this.catalogId(o.getCatalogId());
            this.patternKey(o.getPatternKey());
            this.validatePatternDetails(o.getValidatePatternDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidatePatternRequest build() {
            ValidatePatternRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ValidatePatternDetails body) {
            this.validatePatternDetails(body);
            return this;
        }

        public ValidatePatternRequest buildWithoutInvocationCallback() {
            ValidatePatternRequest request = new ValidatePatternRequest();
            request.catalogId = this.catalogId;
            request.patternKey = this.patternKey;
            request.validatePatternDetails = this.validatePatternDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

