/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateNamespaceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateNamespaceRequest
extends BmcRequest<UpdateNamespaceDetails> {
    private String catalogId;
    private String namespaceId;
    private UpdateNamespaceDetails updateNamespaceDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public UpdateNamespaceDetails getUpdateNamespaceDetails() {
        return this.updateNamespaceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateNamespaceDetails getBody$() {
        return this.updateNamespaceDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).namespaceId(this.namespaceId).updateNamespaceDetails(this.updateNamespaceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",namespaceId=").append(String.valueOf(this.namespaceId));
        sb.append(",updateNamespaceDetails=").append(String.valueOf((Object)this.updateNamespaceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateNamespaceRequest)) {
            return false;
        }
        UpdateNamespaceRequest other = (UpdateNamespaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.namespaceId, other.namespaceId) && Objects.equals((Object)this.updateNamespaceDetails, (Object)other.updateNamespaceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.namespaceId == null ? 43 : this.namespaceId.hashCode());
        result = result * 59 + (this.updateNamespaceDetails == null ? 43 : this.updateNamespaceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateNamespaceRequest, UpdateNamespaceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String namespaceId = null;
        private UpdateNamespaceDetails updateNamespaceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder updateNamespaceDetails(UpdateNamespaceDetails updateNamespaceDetails) {
            this.updateNamespaceDetails = updateNamespaceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateNamespaceRequest o) {
            this.catalogId(o.getCatalogId());
            this.namespaceId(o.getNamespaceId());
            this.updateNamespaceDetails(o.getUpdateNamespaceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateNamespaceRequest build() {
            UpdateNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateNamespaceDetails body) {
            this.updateNamespaceDetails(body);
            return this;
        }

        public UpdateNamespaceRequest buildWithoutInvocationCallback() {
            UpdateNamespaceRequest request = new UpdateNamespaceRequest();
            request.catalogId = this.catalogId;
            request.namespaceId = this.namespaceId;
            request.updateNamespaceDetails = this.updateNamespaceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

