/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateJobDefinitionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateJobDefinitionRequest
extends BmcRequest<UpdateJobDefinitionDetails> {
    private String catalogId;
    private String jobDefinitionKey;
    private UpdateJobDefinitionDetails updateJobDefinitionDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobDefinitionKey() {
        return this.jobDefinitionKey;
    }

    public UpdateJobDefinitionDetails getUpdateJobDefinitionDetails() {
        return this.updateJobDefinitionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateJobDefinitionDetails getBody$() {
        return this.updateJobDefinitionDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).jobDefinitionKey(this.jobDefinitionKey).updateJobDefinitionDetails(this.updateJobDefinitionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",jobDefinitionKey=").append(String.valueOf(this.jobDefinitionKey));
        sb.append(",updateJobDefinitionDetails=").append(String.valueOf((Object)this.updateJobDefinitionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateJobDefinitionRequest)) {
            return false;
        }
        UpdateJobDefinitionRequest other = (UpdateJobDefinitionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.jobDefinitionKey, other.jobDefinitionKey) && Objects.equals((Object)this.updateJobDefinitionDetails, (Object)other.updateJobDefinitionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.jobDefinitionKey == null ? 43 : this.jobDefinitionKey.hashCode());
        result = result * 59 + (this.updateJobDefinitionDetails == null ? 43 : this.updateJobDefinitionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateJobDefinitionRequest, UpdateJobDefinitionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String jobDefinitionKey = null;
        private UpdateJobDefinitionDetails updateJobDefinitionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobDefinitionKey(String jobDefinitionKey) {
            this.jobDefinitionKey = jobDefinitionKey;
            return this;
        }

        public Builder updateJobDefinitionDetails(UpdateJobDefinitionDetails updateJobDefinitionDetails) {
            this.updateJobDefinitionDetails = updateJobDefinitionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateJobDefinitionRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobDefinitionKey(o.getJobDefinitionKey());
            this.updateJobDefinitionDetails(o.getUpdateJobDefinitionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateJobDefinitionRequest build() {
            UpdateJobDefinitionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateJobDefinitionDetails body) {
            this.updateJobDefinitionDetails(body);
            return this;
        }

        public UpdateJobDefinitionRequest buildWithoutInvocationCallback() {
            UpdateJobDefinitionRequest request = new UpdateJobDefinitionRequest();
            request.catalogId = this.catalogId;
            request.jobDefinitionKey = this.jobDefinitionKey;
            request.updateJobDefinitionDetails = this.updateJobDefinitionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

