/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateCustomPropertyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCustomPropertyRequest
extends BmcRequest<UpdateCustomPropertyDetails> {
    private String catalogId;
    private String namespaceId;
    private String customPropertyKey;
    private UpdateCustomPropertyDetails updateCustomPropertyDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getCustomPropertyKey() {
        return this.customPropertyKey;
    }

    public UpdateCustomPropertyDetails getUpdateCustomPropertyDetails() {
        return this.updateCustomPropertyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateCustomPropertyDetails getBody$() {
        return this.updateCustomPropertyDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).namespaceId(this.namespaceId).customPropertyKey(this.customPropertyKey).updateCustomPropertyDetails(this.updateCustomPropertyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",namespaceId=").append(String.valueOf(this.namespaceId));
        sb.append(",customPropertyKey=").append(String.valueOf(this.customPropertyKey));
        sb.append(",updateCustomPropertyDetails=").append(String.valueOf((Object)this.updateCustomPropertyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCustomPropertyRequest)) {
            return false;
        }
        UpdateCustomPropertyRequest other = (UpdateCustomPropertyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.namespaceId, other.namespaceId) && Objects.equals(this.customPropertyKey, other.customPropertyKey) && Objects.equals((Object)this.updateCustomPropertyDetails, (Object)other.updateCustomPropertyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.namespaceId == null ? 43 : this.namespaceId.hashCode());
        result = result * 59 + (this.customPropertyKey == null ? 43 : this.customPropertyKey.hashCode());
        result = result * 59 + (this.updateCustomPropertyDetails == null ? 43 : this.updateCustomPropertyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCustomPropertyRequest, UpdateCustomPropertyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String namespaceId = null;
        private String customPropertyKey = null;
        private UpdateCustomPropertyDetails updateCustomPropertyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder customPropertyKey(String customPropertyKey) {
            this.customPropertyKey = customPropertyKey;
            return this;
        }

        public Builder updateCustomPropertyDetails(UpdateCustomPropertyDetails updateCustomPropertyDetails) {
            this.updateCustomPropertyDetails = updateCustomPropertyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCustomPropertyRequest o) {
            this.catalogId(o.getCatalogId());
            this.namespaceId(o.getNamespaceId());
            this.customPropertyKey(o.getCustomPropertyKey());
            this.updateCustomPropertyDetails(o.getUpdateCustomPropertyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCustomPropertyRequest build() {
            UpdateCustomPropertyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCustomPropertyDetails body) {
            this.updateCustomPropertyDetails(body);
            return this;
        }

        public UpdateCustomPropertyRequest buildWithoutInvocationCallback() {
            UpdateCustomPropertyRequest request = new UpdateCustomPropertyRequest();
            request.catalogId = this.catalogId;
            request.namespaceId = this.namespaceId;
            request.customPropertyKey = this.customPropertyKey;
            request.updateCustomPropertyDetails = this.updateCustomPropertyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

