/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.DataAssetImportExportTypeFilter;
import com.oracle.bmc.datacatalog.model.ExportDataAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SynchronousExportDataAssetRequest
extends BmcRequest<ExportDataAssetDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ExportDataAssetDetails synchronousExportDataAssetDetails;
    private List<DataAssetImportExportTypeFilter> exportType;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ExportDataAssetDetails getSynchronousExportDataAssetDetails() {
        return this.synchronousExportDataAssetDetails;
    }

    public List<DataAssetImportExportTypeFilter> getExportType() {
        return this.exportType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ExportDataAssetDetails getBody$() {
        return this.synchronousExportDataAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).synchronousExportDataAssetDetails(this.synchronousExportDataAssetDetails).exportType(this.exportType).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",synchronousExportDataAssetDetails=").append(String.valueOf((Object)this.synchronousExportDataAssetDetails));
        sb.append(",exportType=").append(String.valueOf(this.exportType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SynchronousExportDataAssetRequest)) {
            return false;
        }
        SynchronousExportDataAssetRequest other = (SynchronousExportDataAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals((Object)this.synchronousExportDataAssetDetails, (Object)other.synchronousExportDataAssetDetails) && Objects.equals(this.exportType, other.exportType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.synchronousExportDataAssetDetails == null ? 43 : this.synchronousExportDataAssetDetails.hashCode());
        result = result * 59 + (this.exportType == null ? 43 : this.exportType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SynchronousExportDataAssetRequest, ExportDataAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private ExportDataAssetDetails synchronousExportDataAssetDetails = null;
        private List<DataAssetImportExportTypeFilter> exportType = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder synchronousExportDataAssetDetails(ExportDataAssetDetails synchronousExportDataAssetDetails) {
            this.synchronousExportDataAssetDetails = synchronousExportDataAssetDetails;
            return this;
        }

        public Builder exportType(List<DataAssetImportExportTypeFilter> exportType) {
            this.exportType = exportType;
            return this;
        }

        public Builder exportType(DataAssetImportExportTypeFilter singularValue) {
            return this.exportType(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SynchronousExportDataAssetRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.synchronousExportDataAssetDetails(o.getSynchronousExportDataAssetDetails());
            this.exportType(o.getExportType());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SynchronousExportDataAssetRequest build() {
            SynchronousExportDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportDataAssetDetails body) {
            this.synchronousExportDataAssetDetails(body);
            return this;
        }

        public SynchronousExportDataAssetRequest buildWithoutInvocationCallback() {
            SynchronousExportDataAssetRequest request = new SynchronousExportDataAssetRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.synchronousExportDataAssetDetails = this.synchronousExportDataAssetDetails;
            request.exportType = this.exportType;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

