/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.JobLifecycleState;
import com.oracle.bmc.datacatalog.model.JobScheduleType;
import com.oracle.bmc.datacatalog.model.JobType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListJobsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String displayName;
    private String displayNameContains;
    private JobLifecycleState lifecycleState;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private JobType jobType;
    private String jobDefinitionKey;
    private String dataAssetKey;
    private String scheduleCronExpression;
    private Date timeScheduleBegin;
    private Date timeScheduleEnd;
    private JobScheduleType scheduleType;
    private String connectionKey;
    private List<Fields> fields;
    private Integer executionCount;
    private Date timeOfLatestExecution;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public JobLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getJobDefinitionKey() {
        return this.jobDefinitionKey;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getScheduleCronExpression() {
        return this.scheduleCronExpression;
    }

    public Date getTimeScheduleBegin() {
        return this.timeScheduleBegin;
    }

    public Date getTimeScheduleEnd() {
        return this.timeScheduleEnd;
    }

    public JobScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public Integer getExecutionCount() {
        return this.executionCount;
    }

    public Date getTimeOfLatestExecution() {
        return this.timeOfLatestExecution;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).displayName(this.displayName).displayNameContains(this.displayNameContains).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).jobType(this.jobType).jobDefinitionKey(this.jobDefinitionKey).dataAssetKey(this.dataAssetKey).scheduleCronExpression(this.scheduleCronExpression).timeScheduleBegin(this.timeScheduleBegin).timeScheduleEnd(this.timeScheduleEnd).scheduleType(this.scheduleType).connectionKey(this.connectionKey).fields(this.fields).executionCount(this.executionCount).timeOfLatestExecution(this.timeOfLatestExecution).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",jobType=").append(String.valueOf((Object)this.jobType));
        sb.append(",jobDefinitionKey=").append(String.valueOf(this.jobDefinitionKey));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",scheduleCronExpression=").append(String.valueOf(this.scheduleCronExpression));
        sb.append(",timeScheduleBegin=").append(String.valueOf(this.timeScheduleBegin));
        sb.append(",timeScheduleEnd=").append(String.valueOf(this.timeScheduleEnd));
        sb.append(",scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",executionCount=").append(String.valueOf(this.executionCount));
        sb.append(",timeOfLatestExecution=").append(String.valueOf(this.timeOfLatestExecution));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals((Object)this.jobType, (Object)other.jobType) && Objects.equals(this.jobDefinitionKey, other.jobDefinitionKey) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.scheduleCronExpression, other.scheduleCronExpression) && Objects.equals(this.timeScheduleBegin, other.timeScheduleBegin) && Objects.equals(this.timeScheduleEnd, other.timeScheduleEnd) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.fields, other.fields) && Objects.equals(this.executionCount, other.executionCount) && Objects.equals(this.timeOfLatestExecution, other.timeOfLatestExecution) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.jobType == null ? 43 : this.jobType.hashCode());
        result = result * 59 + (this.jobDefinitionKey == null ? 43 : this.jobDefinitionKey.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.scheduleCronExpression == null ? 43 : this.scheduleCronExpression.hashCode());
        result = result * 59 + (this.timeScheduleBegin == null ? 43 : this.timeScheduleBegin.hashCode());
        result = result * 59 + (this.timeScheduleEnd == null ? 43 : this.timeScheduleEnd.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.executionCount == null ? 43 : this.executionCount.hashCode());
        result = result * 59 + (this.timeOfLatestExecution == null ? 43 : this.timeOfLatestExecution.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String displayName = null;
        private String displayNameContains = null;
        private JobLifecycleState lifecycleState = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private JobType jobType = null;
        private String jobDefinitionKey = null;
        private String dataAssetKey = null;
        private String scheduleCronExpression = null;
        private Date timeScheduleBegin = null;
        private Date timeScheduleEnd = null;
        private JobScheduleType scheduleType = null;
        private String connectionKey = null;
        private List<Fields> fields = null;
        private Integer executionCount = null;
        private Date timeOfLatestExecution = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(JobLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder jobDefinitionKey(String jobDefinitionKey) {
            this.jobDefinitionKey = jobDefinitionKey;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder scheduleCronExpression(String scheduleCronExpression) {
            this.scheduleCronExpression = scheduleCronExpression;
            return this;
        }

        public Builder timeScheduleBegin(Date timeScheduleBegin) {
            this.timeScheduleBegin = timeScheduleBegin;
            return this;
        }

        public Builder timeScheduleEnd(Date timeScheduleEnd) {
            this.timeScheduleEnd = timeScheduleEnd;
            return this;
        }

        public Builder scheduleType(JobScheduleType scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder executionCount(Integer executionCount) {
            this.executionCount = executionCount;
            return this;
        }

        public Builder timeOfLatestExecution(Date timeOfLatestExecution) {
            this.timeOfLatestExecution = timeOfLatestExecution;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobsRequest o) {
            this.catalogId(o.getCatalogId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.jobType(o.getJobType());
            this.jobDefinitionKey(o.getJobDefinitionKey());
            this.dataAssetKey(o.getDataAssetKey());
            this.scheduleCronExpression(o.getScheduleCronExpression());
            this.timeScheduleBegin(o.getTimeScheduleBegin());
            this.timeScheduleEnd(o.getTimeScheduleEnd());
            this.scheduleType(o.getScheduleType());
            this.connectionKey(o.getConnectionKey());
            this.fields(o.getFields());
            this.executionCount(o.getExecutionCount());
            this.timeOfLatestExecution(o.getTimeOfLatestExecution());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobsRequest build() {
            ListJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJobsRequest buildWithoutInvocationCallback() {
            ListJobsRequest request = new ListJobsRequest();
            request.catalogId = this.catalogId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.lifecycleState = this.lifecycleState;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.jobType = this.jobType;
            request.jobDefinitionKey = this.jobDefinitionKey;
            request.dataAssetKey = this.dataAssetKey;
            request.scheduleCronExpression = this.scheduleCronExpression;
            request.timeScheduleBegin = this.timeScheduleBegin;
            request.timeScheduleEnd = this.timeScheduleEnd;
            request.scheduleType = this.scheduleType;
            request.connectionKey = this.connectionKey;
            request.fields = this.fields;
            request.executionCount = this.executionCount;
            request.timeOfLatestExecution = this.timeOfLatestExecution;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        CatalogId("catalogId"),
        JobDefinitionKey("jobDefinitionKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        CreatedById("createdById"),
        UpdatedById("updatedById"),
        JobType("jobType"),
        ScheduleCronExpression("scheduleCronExpression"),
        TimeScheduleBegin("timeScheduleBegin"),
        ScheduleType("scheduleType"),
        ExecutionCount("executionCount"),
        TimeOfLatestExecution("timeOfLatestExecution"),
        Executions("executions"),
        Uri("uri"),
        JobDefinitionName("jobDefinitionName"),
        ErrorCode("errorCode"),
        ErrorMessage("errorMessage");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

