/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListJobLogsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private String jobExecutionKey;
    private LifecycleState lifecycleState;
    private String severity;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).jobKey(this.jobKey).jobExecutionKey(this.jobExecutionKey).lifecycleState(this.lifecycleState).severity(this.severity).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",jobKey=").append(String.valueOf(this.jobKey));
        sb.append(",jobExecutionKey=").append(String.valueOf(this.jobExecutionKey));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",severity=").append(String.valueOf(this.severity));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJobLogsRequest)) {
            return false;
        }
        ListJobLogsRequest other = (ListJobLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.jobKey, other.jobKey) && Objects.equals(this.jobExecutionKey, other.jobExecutionKey) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.severity, other.severity) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.jobKey == null ? 43 : this.jobKey.hashCode());
        result = result * 59 + (this.jobExecutionKey == null ? 43 : this.jobExecutionKey.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String jobKey = null;
        private String jobExecutionKey = null;
        private LifecycleState lifecycleState = null;
        private String severity = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobLogsRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.jobExecutionKey(o.getJobExecutionKey());
            this.lifecycleState(o.getLifecycleState());
            this.severity(o.getSeverity());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobLogsRequest build() {
            ListJobLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJobLogsRequest buildWithoutInvocationCallback() {
            ListJobLogsRequest request = new ListJobLogsRequest();
            request.catalogId = this.catalogId;
            request.jobKey = this.jobKey;
            request.jobExecutionKey = this.jobExecutionKey;
            request.lifecycleState = this.lifecycleState;
            request.severity = this.severity;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        JobExecutionKey("jobExecutionKey"),
        Severity("severity"),
        TimeCreated("timeCreated"),
        LogMessage("logMessage"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

