/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.datacatalog.model.JobType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListJobExecutionsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private JobExecutionState lifecycleState;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private JobType jobType;
    private String subType;
    private String parentKey;
    private Date timeStart;
    private Date timeEnd;
    private String errorCode;
    private String errorMessage;
    private String processKey;
    private String externalUrl;
    private String eventKey;
    private String dataEntityKey;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public JobExecutionState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getDataEntityKey() {
        return this.dataEntityKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).jobKey(this.jobKey).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).jobType(this.jobType).subType(this.subType).parentKey(this.parentKey).timeStart(this.timeStart).timeEnd(this.timeEnd).errorCode(this.errorCode).errorMessage(this.errorMessage).processKey(this.processKey).externalUrl(this.externalUrl).eventKey(this.eventKey).dataEntityKey(this.dataEntityKey).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",jobKey=").append(String.valueOf(this.jobKey));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",jobType=").append(String.valueOf((Object)this.jobType));
        sb.append(",subType=").append(String.valueOf(this.subType));
        sb.append(",parentKey=").append(String.valueOf(this.parentKey));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",errorCode=").append(String.valueOf(this.errorCode));
        sb.append(",errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(",processKey=").append(String.valueOf(this.processKey));
        sb.append(",externalUrl=").append(String.valueOf(this.externalUrl));
        sb.append(",eventKey=").append(String.valueOf(this.eventKey));
        sb.append(",dataEntityKey=").append(String.valueOf(this.dataEntityKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJobExecutionsRequest)) {
            return false;
        }
        ListJobExecutionsRequest other = (ListJobExecutionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.jobKey, other.jobKey) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals((Object)this.jobType, (Object)other.jobType) && Objects.equals(this.subType, other.subType) && Objects.equals(this.parentKey, other.parentKey) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.processKey, other.processKey) && Objects.equals(this.externalUrl, other.externalUrl) && Objects.equals(this.eventKey, other.eventKey) && Objects.equals(this.dataEntityKey, other.dataEntityKey) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.jobKey == null ? 43 : this.jobKey.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.jobType == null ? 43 : this.jobType.hashCode());
        result = result * 59 + (this.subType == null ? 43 : this.subType.hashCode());
        result = result * 59 + (this.parentKey == null ? 43 : this.parentKey.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.errorCode == null ? 43 : this.errorCode.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.processKey == null ? 43 : this.processKey.hashCode());
        result = result * 59 + (this.externalUrl == null ? 43 : this.externalUrl.hashCode());
        result = result * 59 + (this.eventKey == null ? 43 : this.eventKey.hashCode());
        result = result * 59 + (this.dataEntityKey == null ? 43 : this.dataEntityKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobExecutionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String jobKey = null;
        private JobExecutionState lifecycleState = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private JobType jobType = null;
        private String subType = null;
        private String parentKey = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private String errorCode = null;
        private String errorMessage = null;
        private String processKey = null;
        private String externalUrl = null;
        private String eventKey = null;
        private String dataEntityKey = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder lifecycleState(JobExecutionState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public Builder parentKey(String parentKey) {
            this.parentKey = parentKey;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder processKey(String processKey) {
            this.processKey = processKey;
            return this;
        }

        public Builder externalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            return this;
        }

        public Builder eventKey(String eventKey) {
            this.eventKey = eventKey;
            return this;
        }

        public Builder dataEntityKey(String dataEntityKey) {
            this.dataEntityKey = dataEntityKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobExecutionsRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.jobType(o.getJobType());
            this.subType(o.getSubType());
            this.parentKey(o.getParentKey());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.errorCode(o.getErrorCode());
            this.errorMessage(o.getErrorMessage());
            this.processKey(o.getProcessKey());
            this.externalUrl(o.getExternalUrl());
            this.eventKey(o.getEventKey());
            this.dataEntityKey(o.getDataEntityKey());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobExecutionsRequest build() {
            ListJobExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJobExecutionsRequest buildWithoutInvocationCallback() {
            ListJobExecutionsRequest request = new ListJobExecutionsRequest();
            request.catalogId = this.catalogId;
            request.jobKey = this.jobKey;
            request.lifecycleState = this.lifecycleState;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.jobType = this.jobType;
            request.subType = this.subType;
            request.parentKey = this.parentKey;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.errorCode = this.errorCode;
            request.errorMessage = this.errorMessage;
            request.processKey = this.processKey;
            request.externalUrl = this.externalUrl;
            request.eventKey = this.eventKey;
            request.dataEntityKey = this.dataEntityKey;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        JobKey("jobKey"),
        JobType("jobType"),
        ParentKey("parentKey"),
        ScheduleInstanceKey("scheduleInstanceKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeStarted("timeStarted"),
        TimeEnded("timeEnded"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

