/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.datacatalog.model.JobType;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListJobDefinitionsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String displayName;
    private String displayNameContains;
    private JobExecutionState jobExecutionState;
    private LifecycleState lifecycleState;
    private JobType jobType;
    private Boolean isIncremental;
    private String dataAssetKey;
    private String connectionKey;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private String sampleDataSizeInMBs;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public JobExecutionState getJobExecutionState() {
        return this.jobExecutionState;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public Boolean getIsIncremental() {
        return this.isIncremental;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public String getSampleDataSizeInMBs() {
        return this.sampleDataSizeInMBs;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).displayName(this.displayName).displayNameContains(this.displayNameContains).jobExecutionState(this.jobExecutionState).lifecycleState(this.lifecycleState).jobType(this.jobType).isIncremental(this.isIncremental).dataAssetKey(this.dataAssetKey).connectionKey(this.connectionKey).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).sampleDataSizeInMBs(this.sampleDataSizeInMBs).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",jobExecutionState=").append(String.valueOf((Object)this.jobExecutionState));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",jobType=").append(String.valueOf((Object)this.jobType));
        sb.append(",isIncremental=").append(String.valueOf(this.isIncremental));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",sampleDataSizeInMBs=").append(String.valueOf(this.sampleDataSizeInMBs));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJobDefinitionsRequest)) {
            return false;
        }
        ListJobDefinitionsRequest other = (ListJobDefinitionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.jobExecutionState, (Object)other.jobExecutionState) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.jobType, (Object)other.jobType) && Objects.equals(this.isIncremental, other.isIncremental) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals(this.sampleDataSizeInMBs, other.sampleDataSizeInMBs) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.jobExecutionState == null ? 43 : this.jobExecutionState.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.jobType == null ? 43 : this.jobType.hashCode());
        result = result * 59 + (this.isIncremental == null ? 43 : this.isIncremental.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.sampleDataSizeInMBs == null ? 43 : this.sampleDataSizeInMBs.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobDefinitionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String displayName = null;
        private String displayNameContains = null;
        private JobExecutionState jobExecutionState = null;
        private LifecycleState lifecycleState = null;
        private JobType jobType = null;
        private Boolean isIncremental = null;
        private String dataAssetKey = null;
        private String connectionKey = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private String sampleDataSizeInMBs = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder jobExecutionState(JobExecutionState jobExecutionState) {
            this.jobExecutionState = jobExecutionState;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder isIncremental(Boolean isIncremental) {
            this.isIncremental = isIncremental;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder sampleDataSizeInMBs(String sampleDataSizeInMBs) {
            this.sampleDataSizeInMBs = sampleDataSizeInMBs;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobDefinitionsRequest o) {
            this.catalogId(o.getCatalogId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.jobExecutionState(o.getJobExecutionState());
            this.lifecycleState(o.getLifecycleState());
            this.jobType(o.getJobType());
            this.isIncremental(o.getIsIncremental());
            this.dataAssetKey(o.getDataAssetKey());
            this.connectionKey(o.getConnectionKey());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.sampleDataSizeInMBs(o.getSampleDataSizeInMBs());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobDefinitionsRequest build() {
            ListJobDefinitionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJobDefinitionsRequest buildWithoutInvocationCallback() {
            ListJobDefinitionsRequest request = new ListJobDefinitionsRequest();
            request.catalogId = this.catalogId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.jobExecutionState = this.jobExecutionState;
            request.lifecycleState = this.lifecycleState;
            request.jobType = this.jobType;
            request.isIncremental = this.isIncremental;
            request.dataAssetKey = this.dataAssetKey;
            request.connectionKey = this.connectionKey;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.sampleDataSizeInMBs = this.sampleDataSizeInMBs;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME"),
        Timelatestexecutionstarted("TIMELATESTEXECUTIONSTARTED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        CatalogId("catalogId"),
        JobType("jobType"),
        ConnectionKey("connectionKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        IsSampleDataExtracted("isSampleDataExtracted"),
        Uri("uri"),
        TimeLatestExecutionStarted("timeLatestExecutionStarted"),
        TimeLatestExecutionEnded("timeLatestExecutionEnded"),
        JobExecutionState("jobExecutionState"),
        ScheduleType("scheduleType");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

