/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListAggregatedPhysicalEntitiesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private List<Fields> fields;
    private String displayNameContains;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private Boolean isIncludeProperties;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getIsIncludeProperties() {
        return this.isIncludeProperties;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).entityKey(this.entityKey).fields(this.fields).displayNameContains(this.displayNameContains).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).isIncludeProperties(this.isIncludeProperties).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",entityKey=").append(String.valueOf(this.entityKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",isIncludeProperties=").append(String.valueOf(this.isIncludeProperties));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAggregatedPhysicalEntitiesRequest)) {
            return false;
        }
        ListAggregatedPhysicalEntitiesRequest other = (ListAggregatedPhysicalEntitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.entityKey, other.entityKey) && Objects.equals(this.fields, other.fields) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.isIncludeProperties, other.isIncludeProperties) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.entityKey == null ? 43 : this.entityKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.isIncludeProperties == null ? 43 : this.isIncludeProperties.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAggregatedPhysicalEntitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private String entityKey = null;
        private List<Fields> fields = null;
        private String displayNameContains = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private Boolean isIncludeProperties = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder isIncludeProperties(Boolean isIncludeProperties) {
            this.isIncludeProperties = isIncludeProperties;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAggregatedPhysicalEntitiesRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.fields(o.getFields());
            this.displayNameContains(o.getDisplayNameContains());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.isIncludeProperties(o.getIsIncludeProperties());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAggregatedPhysicalEntitiesRequest build() {
            ListAggregatedPhysicalEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAggregatedPhysicalEntitiesRequest buildWithoutInvocationCallback() {
            ListAggregatedPhysicalEntitiesRequest request = new ListAggregatedPhysicalEntitiesRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.entityKey = this.entityKey;
            request.fields = this.fields;
            request.displayNameContains = this.displayNameContains;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.isIncludeProperties = this.isIncludeProperties;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        DataAssetKey("dataAssetKey"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        CreatedById("createdById"),
        UpdatedById("updatedById"),
        LifecycleState("lifecycleState"),
        ExternalKey("externalKey"),
        TimeExternal("timeExternal"),
        TimeStatusUpdated("timeStatusUpdated"),
        IsLogical("isLogical"),
        IsPartition("isPartition"),
        FolderKey("folderKey"),
        FolderName("folderName"),
        TypeKey("typeKey"),
        Path("path"),
        HarvestStatus("harvestStatus"),
        LastJobKey("lastJobKey"),
        Uri("uri"),
        Properties("properties");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

