/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.DataAssetImportExportTypeFilter;
import com.oracle.bmc.datacatalog.model.ImportDataAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ImportDataAssetRequest
extends BmcRequest<ImportDataAssetDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ImportDataAssetDetails importDataAssetDetails;
    private List<DataAssetImportExportTypeFilter> importType;
    private Boolean isMissingValueIgnored;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ImportDataAssetDetails getImportDataAssetDetails() {
        return this.importDataAssetDetails;
    }

    public List<DataAssetImportExportTypeFilter> getImportType() {
        return this.importType;
    }

    public Boolean getIsMissingValueIgnored() {
        return this.isMissingValueIgnored;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ImportDataAssetDetails getBody$() {
        return this.importDataAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).importDataAssetDetails(this.importDataAssetDetails).importType(this.importType).isMissingValueIgnored(this.isMissingValueIgnored).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",importDataAssetDetails=").append(String.valueOf((Object)this.importDataAssetDetails));
        sb.append(",importType=").append(String.valueOf(this.importType));
        sb.append(",isMissingValueIgnored=").append(String.valueOf(this.isMissingValueIgnored));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportDataAssetRequest)) {
            return false;
        }
        ImportDataAssetRequest other = (ImportDataAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals((Object)this.importDataAssetDetails, (Object)other.importDataAssetDetails) && Objects.equals(this.importType, other.importType) && Objects.equals(this.isMissingValueIgnored, other.isMissingValueIgnored) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.importDataAssetDetails == null ? 43 : this.importDataAssetDetails.hashCode());
        result = result * 59 + (this.importType == null ? 43 : this.importType.hashCode());
        result = result * 59 + (this.isMissingValueIgnored == null ? 43 : this.isMissingValueIgnored.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportDataAssetRequest, ImportDataAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private ImportDataAssetDetails importDataAssetDetails = null;
        private List<DataAssetImportExportTypeFilter> importType = null;
        private Boolean isMissingValueIgnored = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder importDataAssetDetails(ImportDataAssetDetails importDataAssetDetails) {
            this.importDataAssetDetails = importDataAssetDetails;
            return this;
        }

        public Builder importType(List<DataAssetImportExportTypeFilter> importType) {
            this.importType = importType;
            return this;
        }

        public Builder importType(DataAssetImportExportTypeFilter singularValue) {
            return this.importType(Arrays.asList(singularValue));
        }

        public Builder isMissingValueIgnored(Boolean isMissingValueIgnored) {
            this.isMissingValueIgnored = isMissingValueIgnored;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportDataAssetRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.importDataAssetDetails(o.getImportDataAssetDetails());
            this.importType(o.getImportType());
            this.isMissingValueIgnored(o.getIsMissingValueIgnored());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportDataAssetRequest build() {
            ImportDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportDataAssetDetails body) {
            this.importDataAssetDetails(body);
            return this;
        }

        public ImportDataAssetRequest buildWithoutInvocationCallback() {
            ImportDataAssetRequest request = new ImportDataAssetRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.importDataAssetDetails = this.importDataAssetDetails;
            request.importType = this.importType;
            request.isMissingValueIgnored = this.isMissingValueIgnored;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

