/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ImportConnectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportConnectionRequest
extends BmcRequest<ImportConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ImportConnectionDetails importConnectionDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ImportConnectionDetails getImportConnectionDetails() {
        return this.importConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ImportConnectionDetails getBody$() {
        return this.importConnectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).importConnectionDetails(this.importConnectionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",importConnectionDetails=").append(String.valueOf((Object)this.importConnectionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportConnectionRequest)) {
            return false;
        }
        ImportConnectionRequest other = (ImportConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals((Object)this.importConnectionDetails, (Object)other.importConnectionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.importConnectionDetails == null ? 43 : this.importConnectionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportConnectionRequest, ImportConnectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private ImportConnectionDetails importConnectionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder importConnectionDetails(ImportConnectionDetails importConnectionDetails) {
            this.importConnectionDetails = importConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.importConnectionDetails(o.getImportConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportConnectionRequest build() {
            ImportConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportConnectionDetails body) {
            this.importConnectionDetails(body);
            return this;
        }

        public ImportConnectionRequest buildWithoutInvocationCallback() {
            ImportConnectionRequest request = new ImportConnectionRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.importConnectionDetails = this.importConnectionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

