/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetAttributeRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private String attributeKey;
    private Boolean isIncludeObjectRelationships;
    private List<Fields> fields;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public Boolean getIsIncludeObjectRelationships() {
        return this.isIncludeObjectRelationships;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).entityKey(this.entityKey).attributeKey(this.attributeKey).isIncludeObjectRelationships(this.isIncludeObjectRelationships).fields(this.fields).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",entityKey=").append(String.valueOf(this.entityKey));
        sb.append(",attributeKey=").append(String.valueOf(this.attributeKey));
        sb.append(",isIncludeObjectRelationships=").append(String.valueOf(this.isIncludeObjectRelationships));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAttributeRequest)) {
            return false;
        }
        GetAttributeRequest other = (GetAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.entityKey, other.entityKey) && Objects.equals(this.attributeKey, other.attributeKey) && Objects.equals(this.isIncludeObjectRelationships, other.isIncludeObjectRelationships) && Objects.equals(this.fields, other.fields) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.entityKey == null ? 43 : this.entityKey.hashCode());
        result = result * 59 + (this.attributeKey == null ? 43 : this.attributeKey.hashCode());
        result = result * 59 + (this.isIncludeObjectRelationships == null ? 43 : this.isIncludeObjectRelationships.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAttributeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private String entityKey = null;
        private String attributeKey = null;
        private Boolean isIncludeObjectRelationships = null;
        private List<Fields> fields = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public Builder isIncludeObjectRelationships(Boolean isIncludeObjectRelationships) {
            this.isIncludeObjectRelationships = isIncludeObjectRelationships;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAttributeRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.attributeKey(o.getAttributeKey());
            this.isIncludeObjectRelationships(o.getIsIncludeObjectRelationships());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAttributeRequest build() {
            GetAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAttributeRequest buildWithoutInvocationCallback() {
            GetAttributeRequest request = new GetAttributeRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.entityKey = this.entityKey;
            request.attributeKey = this.attributeKey;
            request.isIncludeObjectRelationships = this.isIncludeObjectRelationships;
            request.fields = this.fields;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        EntityKey("entityKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        CreatedById("createdById"),
        UpdatedById("updatedById"),
        ExternalDataType("externalDataType"),
        ExternalKey("externalKey"),
        IsIncrementalData("isIncrementalData"),
        IsNullable("isNullable"),
        Length("length"),
        Position("position"),
        Precision("precision"),
        Scale("scale"),
        TimeExternal("timeExternal"),
        Uri("uri"),
        Properties("properties"),
        Path("path"),
        MinCollectionCount("minCollectionCount"),
        MaxCollectionCount("maxCollectionCount"),
        DatatypeEntityKey("datatypeEntityKey"),
        ExternalDatatypeEntityKey("externalDatatypeEntityKey"),
        ParentAttributeKey("parentAttributeKey"),
        ExternalParentAttributeKey("externalParentAttributeKey"),
        TypeKey("typeKey");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

