/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateTermDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTermRequest
extends BmcRequest<CreateTermDetails> {
    private String catalogId;
    private String glossaryKey;
    private CreateTermDetails createTermDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public CreateTermDetails getCreateTermDetails() {
        return this.createTermDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateTermDetails getBody$() {
        return this.createTermDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).glossaryKey(this.glossaryKey).createTermDetails(this.createTermDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",glossaryKey=").append(String.valueOf(this.glossaryKey));
        sb.append(",createTermDetails=").append(String.valueOf((Object)this.createTermDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTermRequest)) {
            return false;
        }
        CreateTermRequest other = (CreateTermRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.glossaryKey, other.glossaryKey) && Objects.equals((Object)this.createTermDetails, (Object)other.createTermDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.glossaryKey == null ? 43 : this.glossaryKey.hashCode());
        result = result * 59 + (this.createTermDetails == null ? 43 : this.createTermDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTermRequest, CreateTermDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String glossaryKey = null;
        private CreateTermDetails createTermDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder createTermDetails(CreateTermDetails createTermDetails) {
            this.createTermDetails = createTermDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTermRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.createTermDetails(o.getCreateTermDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTermRequest build() {
            CreateTermRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTermDetails body) {
            this.createTermDetails(body);
            return this;
        }

        public CreateTermRequest buildWithoutInvocationCallback() {
            CreateTermRequest request = new CreateTermRequest();
            request.catalogId = this.catalogId;
            request.glossaryKey = this.glossaryKey;
            request.createTermDetails = this.createTermDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

