/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.CustomPropertySetUsage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="customPropertyMembers")
    private final List<CustomPropertySetUsage> customPropertyMembers;
    @JsonProperty(value="properties")
    private final Map<String, Map<String, String>> properties;
    @JsonProperty(value="encProperties")
    private final Map<String, Map<String, String>> encProperties;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;

    @Deprecated
    @ConstructorProperties(value={"description", "displayName", "customPropertyMembers", "properties", "encProperties", "isDefault"})
    public UpdateConnectionDetails(String description, String displayName, List<CustomPropertySetUsage> customPropertyMembers, Map<String, Map<String, String>> properties, Map<String, Map<String, String>> encProperties, Boolean isDefault) {
        this.description = description;
        this.displayName = displayName;
        this.customPropertyMembers = customPropertyMembers;
        this.properties = properties;
        this.encProperties = encProperties;
        this.isDefault = isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<CustomPropertySetUsage> getCustomPropertyMembers() {
        return this.customPropertyMembers;
    }

    public Map<String, Map<String, String>> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String>> getEncProperties() {
        return this.encProperties;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", customPropertyMembers=").append(String.valueOf(this.customPropertyMembers));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(", encProperties=").append(String.valueOf(this.encProperties));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConnectionDetails)) {
            return false;
        }
        UpdateConnectionDetails other = (UpdateConnectionDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.customPropertyMembers, other.customPropertyMembers) && Objects.equals(this.properties, other.properties) && Objects.equals(this.encProperties, other.encProperties) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.customPropertyMembers == null ? 43 : this.customPropertyMembers.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.encProperties == null ? 43 : this.encProperties.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="customPropertyMembers")
        private List<CustomPropertySetUsage> customPropertyMembers;
        @JsonProperty(value="properties")
        private Map<String, Map<String, String>> properties;
        @JsonProperty(value="encProperties")
        private Map<String, Map<String, String>> encProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder customPropertyMembers(List<CustomPropertySetUsage> customPropertyMembers) {
            this.customPropertyMembers = customPropertyMembers;
            this.__explicitlySet__.add("customPropertyMembers");
            return this;
        }

        public Builder properties(Map<String, Map<String, String>> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder encProperties(Map<String, Map<String, String>> encProperties) {
            this.encProperties = encProperties;
            this.__explicitlySet__.add("encProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public UpdateConnectionDetails build() {
            UpdateConnectionDetails model = new UpdateConnectionDetails(this.description, this.displayName, this.customPropertyMembers, this.properties, this.encProperties, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("customPropertyMembers")) {
                this.customPropertyMembers(model.getCustomPropertyMembers());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("encProperties")) {
                this.encProperties(model.getEncProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

