/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.FacetedSearchFilterRequest;
import com.oracle.bmc.datacatalog.model.FacetedSearchSortRequest;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SearchCriteria
extends ExplicitlySetBmcModel {
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="facetedQuery")
    private final String facetedQuery;
    @JsonProperty(value="dimensions")
    private final List<String> dimensions;
    @JsonProperty(value="sort")
    private final List<FacetedSearchSortRequest> sort;
    @JsonProperty(value="filters")
    private final FacetedSearchFilterRequest filters;

    @Deprecated
    @ConstructorProperties(value={"query", "facetedQuery", "dimensions", "sort", "filters"})
    public SearchCriteria(String query, String facetedQuery, List<String> dimensions, List<FacetedSearchSortRequest> sort, FacetedSearchFilterRequest filters) {
        this.query = query;
        this.facetedQuery = facetedQuery;
        this.dimensions = dimensions;
        this.sort = sort;
        this.filters = filters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getQuery() {
        return this.query;
    }

    public String getFacetedQuery() {
        return this.facetedQuery;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public List<FacetedSearchSortRequest> getSort() {
        return this.sort;
    }

    public FacetedSearchFilterRequest getFilters() {
        return this.filters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchCriteria(");
        sb.append("super=").append(super.toString());
        sb.append("query=").append(String.valueOf(this.query));
        sb.append(", facetedQuery=").append(String.valueOf(this.facetedQuery));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", sort=").append(String.valueOf(this.sort));
        sb.append(", filters=").append(String.valueOf((Object)this.filters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)((Object)o);
        return Objects.equals(this.query, other.query) && Objects.equals(this.facetedQuery, other.facetedQuery) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.sort, other.sort) && Objects.equals((Object)this.filters, (Object)other.filters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.facetedQuery == null ? 43 : this.facetedQuery.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.sort == null ? 43 : this.sort.hashCode());
        result = result * 59 + (this.filters == null ? 43 : this.filters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="facetedQuery")
        private String facetedQuery;
        @JsonProperty(value="dimensions")
        private List<String> dimensions;
        @JsonProperty(value="sort")
        private List<FacetedSearchSortRequest> sort;
        @JsonProperty(value="filters")
        private FacetedSearchFilterRequest filters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder facetedQuery(String facetedQuery) {
            this.facetedQuery = facetedQuery;
            this.__explicitlySet__.add("facetedQuery");
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder sort(List<FacetedSearchSortRequest> sort) {
            this.sort = sort;
            this.__explicitlySet__.add("sort");
            return this;
        }

        public Builder filters(FacetedSearchFilterRequest filters) {
            this.filters = filters;
            this.__explicitlySet__.add("filters");
            return this;
        }

        public SearchCriteria build() {
            SearchCriteria model = new SearchCriteria(this.query, this.facetedQuery, this.dimensions, this.sort, this.filters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SearchCriteria model) {
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("facetedQuery")) {
                this.facetedQuery(model.getFacetedQuery());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("sort")) {
                this.sort(model.getSort());
            }
            if (model.wasPropertyExplicitlySet("filters")) {
                this.filters(model.getFilters());
            }
            return this;
        }
    }
}

