/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="jobExecutionKey")
    private final String jobExecutionKey;
    @JsonProperty(value="uri")
    private final String uri;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="severity")
    private final String severity;
    @JsonProperty(value="logMessage")
    private final String logMessage;

    @Deprecated
    @ConstructorProperties(value={"key", "jobExecutionKey", "uri", "timeCreated", "severity", "logMessage"})
    public JobLogSummary(String key, String jobExecutionKey, String uri, Date timeCreated, String severity, String logMessage) {
        this.key = key;
        this.jobExecutionKey = jobExecutionKey;
        this.uri = uri;
        this.timeCreated = timeCreated;
        this.severity = severity;
        this.logMessage = logMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public String getUri() {
        return this.uri;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", jobExecutionKey=").append(String.valueOf(this.jobExecutionKey));
        sb.append(", uri=").append(String.valueOf(this.uri));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(", logMessage=").append(String.valueOf(this.logMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobLogSummary)) {
            return false;
        }
        JobLogSummary other = (JobLogSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.jobExecutionKey, other.jobExecutionKey) && Objects.equals(this.uri, other.uri) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.severity, other.severity) && Objects.equals(this.logMessage, other.logMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.jobExecutionKey == null ? 43 : this.jobExecutionKey.hashCode());
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.logMessage == null ? 43 : this.logMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="jobExecutionKey")
        private String jobExecutionKey;
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="severity")
        private String severity;
        @JsonProperty(value="logMessage")
        private String logMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            this.__explicitlySet__.add("jobExecutionKey");
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder logMessage(String logMessage) {
            this.logMessage = logMessage;
            this.__explicitlySet__.add("logMessage");
            return this;
        }

        public JobLogSummary build() {
            JobLogSummary model = new JobLogSummary(this.key, this.jobExecutionKey, this.uri, this.timeCreated, this.severity, this.logMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobLogSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("jobExecutionKey")) {
                this.jobExecutionKey(model.getJobExecutionKey());
            }
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("logMessage")) {
                this.logMessage(model.getLogMessage());
            }
            return this;
        }
    }
}

