/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.EventConfigStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EventConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="typeId")
    private final String typeId;
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonProperty(value="propertyId")
    private final String propertyId;
    @JsonProperty(value="propertyName")
    private final String propertyName;
    @JsonProperty(value="eventConfigStatus")
    private final EventConfigStatus eventConfigStatus;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="createdById")
    private final String createdById;
    @JsonProperty(value="updatedById")
    private final String updatedById;

    @Deprecated
    @ConstructorProperties(value={"typeId", "typeName", "propertyId", "propertyName", "eventConfigStatus", "timeCreated", "timeUpdated", "createdById", "updatedById"})
    public EventConfig(String typeId, String typeName, String propertyId, String propertyName, EventConfigStatus eventConfigStatus, Date timeCreated, Date timeUpdated, String createdById, String updatedById) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.propertyId = propertyId;
        this.propertyName = propertyName;
        this.eventConfigStatus = eventConfigStatus;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.createdById = createdById;
        this.updatedById = updatedById;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EventConfigStatus getEventConfigStatus() {
        return this.eventConfigStatus;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EventConfig(");
        sb.append("super=").append(super.toString());
        sb.append("typeId=").append(String.valueOf(this.typeId));
        sb.append(", typeName=").append(String.valueOf(this.typeName));
        sb.append(", propertyId=").append(String.valueOf(this.propertyId));
        sb.append(", propertyName=").append(String.valueOf(this.propertyName));
        sb.append(", eventConfigStatus=").append(String.valueOf((Object)this.eventConfigStatus));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", createdById=").append(String.valueOf(this.createdById));
        sb.append(", updatedById=").append(String.valueOf(this.updatedById));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventConfig)) {
            return false;
        }
        EventConfig other = (EventConfig)((Object)o);
        return Objects.equals(this.typeId, other.typeId) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.propertyId, other.propertyId) && Objects.equals(this.propertyName, other.propertyName) && Objects.equals((Object)this.eventConfigStatus, (Object)other.eventConfigStatus) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.typeId == null ? 43 : this.typeId.hashCode());
        result = result * 59 + (this.typeName == null ? 43 : this.typeName.hashCode());
        result = result * 59 + (this.propertyId == null ? 43 : this.propertyId.hashCode());
        result = result * 59 + (this.propertyName == null ? 43 : this.propertyName.hashCode());
        result = result * 59 + (this.eventConfigStatus == null ? 43 : this.eventConfigStatus.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="typeId")
        private String typeId;
        @JsonProperty(value="typeName")
        private String typeName;
        @JsonProperty(value="propertyId")
        private String propertyId;
        @JsonProperty(value="propertyName")
        private String propertyName;
        @JsonProperty(value="eventConfigStatus")
        private EventConfigStatus eventConfigStatus;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="createdById")
        private String createdById;
        @JsonProperty(value="updatedById")
        private String updatedById;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder typeId(String typeId) {
            this.typeId = typeId;
            this.__explicitlySet__.add("typeId");
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            this.__explicitlySet__.add("typeName");
            return this;
        }

        public Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            this.__explicitlySet__.add("propertyId");
            return this;
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.__explicitlySet__.add("propertyName");
            return this;
        }

        public Builder eventConfigStatus(EventConfigStatus eventConfigStatus) {
            this.eventConfigStatus = eventConfigStatus;
            this.__explicitlySet__.add("eventConfigStatus");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            this.__explicitlySet__.add("createdById");
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            this.__explicitlySet__.add("updatedById");
            return this;
        }

        public EventConfig build() {
            EventConfig model = new EventConfig(this.typeId, this.typeName, this.propertyId, this.propertyName, this.eventConfigStatus, this.timeCreated, this.timeUpdated, this.createdById, this.updatedById);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EventConfig model) {
            if (model.wasPropertyExplicitlySet("typeId")) {
                this.typeId(model.getTypeId());
            }
            if (model.wasPropertyExplicitlySet("typeName")) {
                this.typeName(model.getTypeName());
            }
            if (model.wasPropertyExplicitlySet("propertyId")) {
                this.propertyId(model.getPropertyId());
            }
            if (model.wasPropertyExplicitlySet("propertyName")) {
                this.propertyName(model.getPropertyName());
            }
            if (model.wasPropertyExplicitlySet("eventConfigStatus")) {
                this.eventConfigStatus(model.getEventConfigStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("createdById")) {
                this.createdById(model.getCreatedById());
            }
            if (model.wasPropertyExplicitlySet("updatedById")) {
                this.updatedById(model.getUpdatedById());
            }
            return this;
        }
    }
}

