/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataAssetTag
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataAssetKey")
    private final String dataAssetKey;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="termKey")
    private final String termKey;
    @JsonProperty(value="termPath")
    private final String termPath;
    @JsonProperty(value="termDescription")
    private final String termDescription;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="createdById")
    private final String createdById;
    @JsonProperty(value="uri")
    private final String uri;

    @Deprecated
    @ConstructorProperties(value={"dataAssetKey", "key", "name", "termKey", "termPath", "termDescription", "lifecycleState", "timeCreated", "createdById", "uri"})
    public DataAssetTag(String dataAssetKey, String key, String name, String termKey, String termPath, String termDescription, LifecycleState lifecycleState, Date timeCreated, String createdById, String uri) {
        this.dataAssetKey = dataAssetKey;
        this.key = key;
        this.name = name;
        this.termKey = termKey;
        this.termPath = termPath;
        this.termDescription = termDescription;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.createdById = createdById;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getTermKey() {
        return this.termKey;
    }

    public String getTermPath() {
        return this.termPath;
    }

    public String getTermDescription() {
        return this.termDescription;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAssetTag(");
        sb.append("super=").append(super.toString());
        sb.append("dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", termKey=").append(String.valueOf(this.termKey));
        sb.append(", termPath=").append(String.valueOf(this.termPath));
        sb.append(", termDescription=").append(String.valueOf(this.termDescription));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", createdById=").append(String.valueOf(this.createdById));
        sb.append(", uri=").append(String.valueOf(this.uri));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAssetTag)) {
            return false;
        }
        DataAssetTag other = (DataAssetTag)((Object)o);
        return Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.termKey, other.termKey) && Objects.equals(this.termPath, other.termPath) && Objects.equals(this.termDescription, other.termDescription) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.uri, other.uri) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.termKey == null ? 43 : this.termKey.hashCode());
        result = result * 59 + (this.termPath == null ? 43 : this.termPath.hashCode());
        result = result * 59 + (this.termDescription == null ? 43 : this.termDescription.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataAssetKey")
        private String dataAssetKey;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="termKey")
        private String termKey;
        @JsonProperty(value="termPath")
        private String termPath;
        @JsonProperty(value="termDescription")
        private String termDescription;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="createdById")
        private String createdById;
        @JsonProperty(value="uri")
        private String uri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            this.__explicitlySet__.add("dataAssetKey");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder termKey(String termKey) {
            this.termKey = termKey;
            this.__explicitlySet__.add("termKey");
            return this;
        }

        public Builder termPath(String termPath) {
            this.termPath = termPath;
            this.__explicitlySet__.add("termPath");
            return this;
        }

        public Builder termDescription(String termDescription) {
            this.termDescription = termDescription;
            this.__explicitlySet__.add("termDescription");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            this.__explicitlySet__.add("createdById");
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public DataAssetTag build() {
            DataAssetTag model = new DataAssetTag(this.dataAssetKey, this.key, this.name, this.termKey, this.termPath, this.termDescription, this.lifecycleState, this.timeCreated, this.createdById, this.uri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataAssetTag model) {
            if (model.wasPropertyExplicitlySet("dataAssetKey")) {
                this.dataAssetKey(model.getDataAssetKey());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("termKey")) {
                this.termKey(model.getTermKey());
            }
            if (model.wasPropertyExplicitlySet("termPath")) {
                this.termPath(model.getTermPath());
            }
            if (model.wasPropertyExplicitlySet("termDescription")) {
                this.termDescription(model.getTermDescription());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("createdById")) {
                this.createdById(model.getCreatedById());
            }
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            return this;
        }
    }
}

