/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataAssetExportScope
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objectKey")
    private final String objectKey;
    @JsonProperty(value="exportTypeIds")
    private final List<String> exportTypeIds;

    @Deprecated
    @ConstructorProperties(value={"objectKey", "exportTypeIds"})
    public DataAssetExportScope(String objectKey, List<String> exportTypeIds) {
        this.objectKey = objectKey;
        this.exportTypeIds = exportTypeIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public List<String> getExportTypeIds() {
        return this.exportTypeIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAssetExportScope(");
        sb.append("super=").append(super.toString());
        sb.append("objectKey=").append(String.valueOf(this.objectKey));
        sb.append(", exportTypeIds=").append(String.valueOf(this.exportTypeIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAssetExportScope)) {
            return false;
        }
        DataAssetExportScope other = (DataAssetExportScope)((Object)o);
        return Objects.equals(this.objectKey, other.objectKey) && Objects.equals(this.exportTypeIds, other.exportTypeIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objectKey == null ? 43 : this.objectKey.hashCode());
        result = result * 59 + (this.exportTypeIds == null ? 43 : this.exportTypeIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectKey")
        private String objectKey;
        @JsonProperty(value="exportTypeIds")
        private List<String> exportTypeIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            this.__explicitlySet__.add("objectKey");
            return this;
        }

        public Builder exportTypeIds(List<String> exportTypeIds) {
            this.exportTypeIds = exportTypeIds;
            this.__explicitlySet__.add("exportTypeIds");
            return this;
        }

        public DataAssetExportScope build() {
            DataAssetExportScope model = new DataAssetExportScope(this.objectKey, this.exportTypeIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataAssetExportScope model) {
            if (model.wasPropertyExplicitlySet("objectKey")) {
                this.objectKey(model.getObjectKey());
            }
            if (model.wasPropertyExplicitlySet("exportTypeIds")) {
                this.exportTypeIds(model.getExportTypeIds());
            }
            return this;
        }
    }
}

