/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomPropertyTypeUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="typeId")
    private final String typeId;
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="isEventEnabled")
    private final Boolean isEventEnabled;

    @Deprecated
    @ConstructorProperties(value={"typeId", "typeName", "count", "isEventEnabled"})
    public CustomPropertyTypeUsage(String typeId, String typeName, Integer count, Boolean isEventEnabled) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.count = count;
        this.isEventEnabled = isEventEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getCount() {
        return this.count;
    }

    public Boolean getIsEventEnabled() {
        return this.isEventEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomPropertyTypeUsage(");
        sb.append("super=").append(super.toString());
        sb.append("typeId=").append(String.valueOf(this.typeId));
        sb.append(", typeName=").append(String.valueOf(this.typeName));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", isEventEnabled=").append(String.valueOf(this.isEventEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomPropertyTypeUsage)) {
            return false;
        }
        CustomPropertyTypeUsage other = (CustomPropertyTypeUsage)((Object)o);
        return Objects.equals(this.typeId, other.typeId) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.count, other.count) && Objects.equals(this.isEventEnabled, other.isEventEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.typeId == null ? 43 : this.typeId.hashCode());
        result = result * 59 + (this.typeName == null ? 43 : this.typeName.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.isEventEnabled == null ? 43 : this.isEventEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="typeId")
        private String typeId;
        @JsonProperty(value="typeName")
        private String typeName;
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="isEventEnabled")
        private Boolean isEventEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder typeId(String typeId) {
            this.typeId = typeId;
            this.__explicitlySet__.add("typeId");
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            this.__explicitlySet__.add("typeName");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder isEventEnabled(Boolean isEventEnabled) {
            this.isEventEnabled = isEventEnabled;
            this.__explicitlySet__.add("isEventEnabled");
            return this;
        }

        public CustomPropertyTypeUsage build() {
            CustomPropertyTypeUsage model = new CustomPropertyTypeUsage(this.typeId, this.typeName, this.count, this.isEventEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomPropertyTypeUsage model) {
            if (model.wasPropertyExplicitlySet("typeId")) {
                this.typeId(model.getTypeId());
            }
            if (model.wasPropertyExplicitlySet("typeName")) {
                this.typeName(model.getTypeName());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("isEventEnabled")) {
                this.isEventEnabled(model.getIsEventEnabled());
            }
            return this;
        }
    }
}

