/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CustomPropertyDataType implements BmcEnum
{
    Text("TEXT"),
    RichText("RICH_TEXT"),
    Boolean("BOOLEAN"),
    Number("NUMBER"),
    Date("DATE"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, CustomPropertyDataType> map;

    private CustomPropertyDataType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static CustomPropertyDataType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'CustomPropertyDataType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(CustomPropertyDataType.class);
        map = new HashMap<String, CustomPropertyDataType>();
        for (CustomPropertyDataType v : CustomPropertyDataType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

