/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Catalog
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="serviceApiUrl")
    private final String serviceApiUrl;
    @JsonProperty(value="serviceConsoleUrl")
    private final String serviceConsoleUrl;
    @JsonProperty(value="numberOfObjects")
    private final Integer numberOfObjects;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="attachedCatalogPrivateEndpoints")
    private final List<String> attachedCatalogPrivateEndpoints;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "timeCreated", "timeUpdated", "serviceApiUrl", "serviceConsoleUrl", "numberOfObjects", "lifecycleState", "lifecycleDetails", "freeformTags", "definedTags", "attachedCatalogPrivateEndpoints"})
    public Catalog(String id, String displayName, String compartmentId, Date timeCreated, Date timeUpdated, String serviceApiUrl, String serviceConsoleUrl, Integer numberOfObjects, LifecycleState lifecycleState, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<String> attachedCatalogPrivateEndpoints) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.serviceApiUrl = serviceApiUrl;
        this.serviceConsoleUrl = serviceConsoleUrl;
        this.numberOfObjects = numberOfObjects;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.attachedCatalogPrivateEndpoints = attachedCatalogPrivateEndpoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getServiceApiUrl() {
        return this.serviceApiUrl;
    }

    public String getServiceConsoleUrl() {
        return this.serviceConsoleUrl;
    }

    public Integer getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<String> getAttachedCatalogPrivateEndpoints() {
        return this.attachedCatalogPrivateEndpoints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Catalog(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", serviceApiUrl=").append(String.valueOf(this.serviceApiUrl));
        sb.append(", serviceConsoleUrl=").append(String.valueOf(this.serviceConsoleUrl));
        sb.append(", numberOfObjects=").append(String.valueOf(this.numberOfObjects));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", attachedCatalogPrivateEndpoints=").append(String.valueOf(this.attachedCatalogPrivateEndpoints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Catalog)) {
            return false;
        }
        Catalog other = (Catalog)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.serviceApiUrl, other.serviceApiUrl) && Objects.equals(this.serviceConsoleUrl, other.serviceConsoleUrl) && Objects.equals(this.numberOfObjects, other.numberOfObjects) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.attachedCatalogPrivateEndpoints, other.attachedCatalogPrivateEndpoints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.serviceApiUrl == null ? 43 : this.serviceApiUrl.hashCode());
        result = result * 59 + (this.serviceConsoleUrl == null ? 43 : this.serviceConsoleUrl.hashCode());
        result = result * 59 + (this.numberOfObjects == null ? 43 : this.numberOfObjects.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.attachedCatalogPrivateEndpoints == null ? 43 : this.attachedCatalogPrivateEndpoints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="serviceApiUrl")
        private String serviceApiUrl;
        @JsonProperty(value="serviceConsoleUrl")
        private String serviceConsoleUrl;
        @JsonProperty(value="numberOfObjects")
        private Integer numberOfObjects;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="attachedCatalogPrivateEndpoints")
        private List<String> attachedCatalogPrivateEndpoints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder serviceApiUrl(String serviceApiUrl) {
            this.serviceApiUrl = serviceApiUrl;
            this.__explicitlySet__.add("serviceApiUrl");
            return this;
        }

        public Builder serviceConsoleUrl(String serviceConsoleUrl) {
            this.serviceConsoleUrl = serviceConsoleUrl;
            this.__explicitlySet__.add("serviceConsoleUrl");
            return this;
        }

        public Builder numberOfObjects(Integer numberOfObjects) {
            this.numberOfObjects = numberOfObjects;
            this.__explicitlySet__.add("numberOfObjects");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder attachedCatalogPrivateEndpoints(List<String> attachedCatalogPrivateEndpoints) {
            this.attachedCatalogPrivateEndpoints = attachedCatalogPrivateEndpoints;
            this.__explicitlySet__.add("attachedCatalogPrivateEndpoints");
            return this;
        }

        public Catalog build() {
            Catalog model = new Catalog(this.id, this.displayName, this.compartmentId, this.timeCreated, this.timeUpdated, this.serviceApiUrl, this.serviceConsoleUrl, this.numberOfObjects, this.lifecycleState, this.lifecycleDetails, this.freeformTags, this.definedTags, this.attachedCatalogPrivateEndpoints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Catalog model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("serviceApiUrl")) {
                this.serviceApiUrl(model.getServiceApiUrl());
            }
            if (model.wasPropertyExplicitlySet("serviceConsoleUrl")) {
                this.serviceConsoleUrl(model.getServiceConsoleUrl());
            }
            if (model.wasPropertyExplicitlySet("numberOfObjects")) {
                this.numberOfObjects(model.getNumberOfObjects());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("attachedCatalogPrivateEndpoints")) {
                this.attachedCatalogPrivateEndpoints(model.getAttachedCatalogPrivateEndpoints());
            }
            return this;
        }
    }
}

