/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.AdminCredentials;
import com.oracle.bmc.databasemigration.model.ConnectDescriptor;
import com.oracle.bmc.databasemigration.model.DatabaseConnectionTypes;
import com.oracle.bmc.databasemigration.model.DatabaseManualConnectionSubTypes;
import com.oracle.bmc.databasemigration.model.LifecycleStates;
import com.oracle.bmc.databasemigration.model.PrivateEndpointDetails;
import com.oracle.bmc.databasemigration.model.SshDetails;
import com.oracle.bmc.databasemigration.model.VaultDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Connection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseType")
    private final DatabaseConnectionTypes databaseType;
    @JsonProperty(value="manualDatabaseSubType")
    private final DatabaseManualConnectionSubTypes manualDatabaseSubType;
    @JsonProperty(value="isDedicated")
    private final Boolean isDedicated;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="connectDescriptor")
    private final ConnectDescriptor connectDescriptor;
    @JsonProperty(value="credentialsSecretId")
    private final String credentialsSecretId;
    @JsonProperty(value="certificateTdn")
    private final String certificateTdn;
    @JsonProperty(value="sshDetails")
    private final SshDetails sshDetails;
    @JsonProperty(value="adminCredentials")
    private final AdminCredentials adminCredentials;
    @JsonProperty(value="privateEndpoint")
    private final PrivateEndpointDetails privateEndpoint;
    @JsonProperty(value="vaultDetails")
    private final VaultDetails vaultDetails;
    @JsonProperty(value="lifecycleState")
    private final LifecycleStates lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "databaseType", "manualDatabaseSubType", "isDedicated", "displayName", "databaseId", "connectDescriptor", "credentialsSecretId", "certificateTdn", "sshDetails", "adminCredentials", "privateEndpoint", "vaultDetails", "lifecycleState", "lifecycleDetails", "timeCreated", "timeUpdated", "freeformTags", "definedTags", "systemTags"})
    public Connection(String id, String compartmentId, DatabaseConnectionTypes databaseType, DatabaseManualConnectionSubTypes manualDatabaseSubType, Boolean isDedicated, String displayName, String databaseId, ConnectDescriptor connectDescriptor, String credentialsSecretId, String certificateTdn, SshDetails sshDetails, AdminCredentials adminCredentials, PrivateEndpointDetails privateEndpoint, VaultDetails vaultDetails, LifecycleStates lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.databaseType = databaseType;
        this.manualDatabaseSubType = manualDatabaseSubType;
        this.isDedicated = isDedicated;
        this.displayName = displayName;
        this.databaseId = databaseId;
        this.connectDescriptor = connectDescriptor;
        this.credentialsSecretId = credentialsSecretId;
        this.certificateTdn = certificateTdn;
        this.sshDetails = sshDetails;
        this.adminCredentials = adminCredentials;
        this.privateEndpoint = privateEndpoint;
        this.vaultDetails = vaultDetails;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public DatabaseConnectionTypes getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseManualConnectionSubTypes getManualDatabaseSubType() {
        return this.manualDatabaseSubType;
    }

    public Boolean getIsDedicated() {
        return this.isDedicated;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public ConnectDescriptor getConnectDescriptor() {
        return this.connectDescriptor;
    }

    public String getCredentialsSecretId() {
        return this.credentialsSecretId;
    }

    public String getCertificateTdn() {
        return this.certificateTdn;
    }

    public SshDetails getSshDetails() {
        return this.sshDetails;
    }

    public AdminCredentials getAdminCredentials() {
        return this.adminCredentials;
    }

    public PrivateEndpointDetails getPrivateEndpoint() {
        return this.privateEndpoint;
    }

    public VaultDetails getVaultDetails() {
        return this.vaultDetails;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Connection(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", manualDatabaseSubType=").append(String.valueOf((Object)this.manualDatabaseSubType));
        sb.append(", isDedicated=").append(String.valueOf(this.isDedicated));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", connectDescriptor=").append(String.valueOf((Object)this.connectDescriptor));
        sb.append(", credentialsSecretId=").append(String.valueOf(this.credentialsSecretId));
        sb.append(", certificateTdn=").append(String.valueOf(this.certificateTdn));
        sb.append(", sshDetails=").append(String.valueOf((Object)this.sshDetails));
        sb.append(", adminCredentials=").append(String.valueOf((Object)this.adminCredentials));
        sb.append(", privateEndpoint=").append(String.valueOf((Object)this.privateEndpoint));
        sb.append(", vaultDetails=").append(String.valueOf((Object)this.vaultDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.manualDatabaseSubType, (Object)other.manualDatabaseSubType) && Objects.equals(this.isDedicated, other.isDedicated) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.connectDescriptor, (Object)other.connectDescriptor) && Objects.equals(this.credentialsSecretId, other.credentialsSecretId) && Objects.equals(this.certificateTdn, other.certificateTdn) && Objects.equals((Object)this.sshDetails, (Object)other.sshDetails) && Objects.equals((Object)this.adminCredentials, (Object)other.adminCredentials) && Objects.equals((Object)this.privateEndpoint, (Object)other.privateEndpoint) && Objects.equals((Object)this.vaultDetails, (Object)other.vaultDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.manualDatabaseSubType == null ? 43 : this.manualDatabaseSubType.hashCode());
        result = result * 59 + (this.isDedicated == null ? 43 : this.isDedicated.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.connectDescriptor == null ? 43 : this.connectDescriptor.hashCode());
        result = result * 59 + (this.credentialsSecretId == null ? 43 : this.credentialsSecretId.hashCode());
        result = result * 59 + (this.certificateTdn == null ? 43 : this.certificateTdn.hashCode());
        result = result * 59 + (this.sshDetails == null ? 43 : this.sshDetails.hashCode());
        result = result * 59 + (this.adminCredentials == null ? 43 : this.adminCredentials.hashCode());
        result = result * 59 + (this.privateEndpoint == null ? 43 : this.privateEndpoint.hashCode());
        result = result * 59 + (this.vaultDetails == null ? 43 : this.vaultDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseType")
        private DatabaseConnectionTypes databaseType;
        @JsonProperty(value="manualDatabaseSubType")
        private DatabaseManualConnectionSubTypes manualDatabaseSubType;
        @JsonProperty(value="isDedicated")
        private Boolean isDedicated;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="connectDescriptor")
        private ConnectDescriptor connectDescriptor;
        @JsonProperty(value="credentialsSecretId")
        private String credentialsSecretId;
        @JsonProperty(value="certificateTdn")
        private String certificateTdn;
        @JsonProperty(value="sshDetails")
        private SshDetails sshDetails;
        @JsonProperty(value="adminCredentials")
        private AdminCredentials adminCredentials;
        @JsonProperty(value="privateEndpoint")
        private PrivateEndpointDetails privateEndpoint;
        @JsonProperty(value="vaultDetails")
        private VaultDetails vaultDetails;
        @JsonProperty(value="lifecycleState")
        private LifecycleStates lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseType(DatabaseConnectionTypes databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder manualDatabaseSubType(DatabaseManualConnectionSubTypes manualDatabaseSubType) {
            this.manualDatabaseSubType = manualDatabaseSubType;
            this.__explicitlySet__.add("manualDatabaseSubType");
            return this;
        }

        public Builder isDedicated(Boolean isDedicated) {
            this.isDedicated = isDedicated;
            this.__explicitlySet__.add("isDedicated");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder connectDescriptor(ConnectDescriptor connectDescriptor) {
            this.connectDescriptor = connectDescriptor;
            this.__explicitlySet__.add("connectDescriptor");
            return this;
        }

        public Builder credentialsSecretId(String credentialsSecretId) {
            this.credentialsSecretId = credentialsSecretId;
            this.__explicitlySet__.add("credentialsSecretId");
            return this;
        }

        public Builder certificateTdn(String certificateTdn) {
            this.certificateTdn = certificateTdn;
            this.__explicitlySet__.add("certificateTdn");
            return this;
        }

        public Builder sshDetails(SshDetails sshDetails) {
            this.sshDetails = sshDetails;
            this.__explicitlySet__.add("sshDetails");
            return this;
        }

        public Builder adminCredentials(AdminCredentials adminCredentials) {
            this.adminCredentials = adminCredentials;
            this.__explicitlySet__.add("adminCredentials");
            return this;
        }

        public Builder privateEndpoint(PrivateEndpointDetails privateEndpoint) {
            this.privateEndpoint = privateEndpoint;
            this.__explicitlySet__.add("privateEndpoint");
            return this;
        }

        public Builder vaultDetails(VaultDetails vaultDetails) {
            this.vaultDetails = vaultDetails;
            this.__explicitlySet__.add("vaultDetails");
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Connection build() {
            Connection model = new Connection(this.id, this.compartmentId, this.databaseType, this.manualDatabaseSubType, this.isDedicated, this.displayName, this.databaseId, this.connectDescriptor, this.credentialsSecretId, this.certificateTdn, this.sshDetails, this.adminCredentials, this.privateEndpoint, this.vaultDetails, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Connection model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("manualDatabaseSubType")) {
                this.manualDatabaseSubType(model.getManualDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("isDedicated")) {
                this.isDedicated(model.getIsDedicated());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("connectDescriptor")) {
                this.connectDescriptor(model.getConnectDescriptor());
            }
            if (model.wasPropertyExplicitlySet("credentialsSecretId")) {
                this.credentialsSecretId(model.getCredentialsSecretId());
            }
            if (model.wasPropertyExplicitlySet("certificateTdn")) {
                this.certificateTdn(model.getCertificateTdn());
            }
            if (model.wasPropertyExplicitlySet("sshDetails")) {
                this.sshDetails(model.getSshDetails());
            }
            if (model.wasPropertyExplicitlySet("adminCredentials")) {
                this.adminCredentials(model.getAdminCredentials());
            }
            if (model.wasPropertyExplicitlySet("privateEndpoint")) {
                this.privateEndpoint(model.getPrivateEndpoint());
            }
            if (model.wasPropertyExplicitlySet("vaultDetails")) {
                this.vaultDetails(model.getVaultDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

