/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CreateVaultDetails;
import com.oracle.bmc.databasemigration.model.DatabaseObject;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloneMigrationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="sourceDatabaseConnectionId")
    private final String sourceDatabaseConnectionId;
    @JsonProperty(value="sourceContainerDatabaseConnectionId")
    private final String sourceContainerDatabaseConnectionId;
    @JsonProperty(value="targetDatabaseConnectionId")
    private final String targetDatabaseConnectionId;
    @JsonProperty(value="excludeObjects")
    private final List<DatabaseObject> excludeObjects;
    @JsonProperty(value="includeObjects")
    private final List<DatabaseObject> includeObjects;
    @JsonProperty(value="vaultDetails")
    private final CreateVaultDetails vaultDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "agentId", "sourceDatabaseConnectionId", "sourceContainerDatabaseConnectionId", "targetDatabaseConnectionId", "excludeObjects", "includeObjects", "vaultDetails", "freeformTags", "definedTags"})
    public CloneMigrationDetails(String displayName, String compartmentId, String agentId, String sourceDatabaseConnectionId, String sourceContainerDatabaseConnectionId, String targetDatabaseConnectionId, List<DatabaseObject> excludeObjects, List<DatabaseObject> includeObjects, CreateVaultDetails vaultDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.agentId = agentId;
        this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
        this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
        this.targetDatabaseConnectionId = targetDatabaseConnectionId;
        this.excludeObjects = excludeObjects;
        this.includeObjects = includeObjects;
        this.vaultDetails = vaultDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getSourceDatabaseConnectionId() {
        return this.sourceDatabaseConnectionId;
    }

    public String getSourceContainerDatabaseConnectionId() {
        return this.sourceContainerDatabaseConnectionId;
    }

    public String getTargetDatabaseConnectionId() {
        return this.targetDatabaseConnectionId;
    }

    public List<DatabaseObject> getExcludeObjects() {
        return this.excludeObjects;
    }

    public List<DatabaseObject> getIncludeObjects() {
        return this.includeObjects;
    }

    public CreateVaultDetails getVaultDetails() {
        return this.vaultDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloneMigrationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", sourceDatabaseConnectionId=").append(String.valueOf(this.sourceDatabaseConnectionId));
        sb.append(", sourceContainerDatabaseConnectionId=").append(String.valueOf(this.sourceContainerDatabaseConnectionId));
        sb.append(", targetDatabaseConnectionId=").append(String.valueOf(this.targetDatabaseConnectionId));
        sb.append(", excludeObjects=").append(String.valueOf(this.excludeObjects));
        sb.append(", includeObjects=").append(String.valueOf(this.includeObjects));
        sb.append(", vaultDetails=").append(String.valueOf((Object)this.vaultDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloneMigrationDetails)) {
            return false;
        }
        CloneMigrationDetails other = (CloneMigrationDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.sourceDatabaseConnectionId, other.sourceDatabaseConnectionId) && Objects.equals(this.sourceContainerDatabaseConnectionId, other.sourceContainerDatabaseConnectionId) && Objects.equals(this.targetDatabaseConnectionId, other.targetDatabaseConnectionId) && Objects.equals(this.excludeObjects, other.excludeObjects) && Objects.equals(this.includeObjects, other.includeObjects) && Objects.equals((Object)this.vaultDetails, (Object)other.vaultDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.sourceDatabaseConnectionId == null ? 43 : this.sourceDatabaseConnectionId.hashCode());
        result = result * 59 + (this.sourceContainerDatabaseConnectionId == null ? 43 : this.sourceContainerDatabaseConnectionId.hashCode());
        result = result * 59 + (this.targetDatabaseConnectionId == null ? 43 : this.targetDatabaseConnectionId.hashCode());
        result = result * 59 + (this.excludeObjects == null ? 43 : this.excludeObjects.hashCode());
        result = result * 59 + (this.includeObjects == null ? 43 : this.includeObjects.hashCode());
        result = result * 59 + (this.vaultDetails == null ? 43 : this.vaultDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="sourceDatabaseConnectionId")
        private String sourceDatabaseConnectionId;
        @JsonProperty(value="sourceContainerDatabaseConnectionId")
        private String sourceContainerDatabaseConnectionId;
        @JsonProperty(value="targetDatabaseConnectionId")
        private String targetDatabaseConnectionId;
        @JsonProperty(value="excludeObjects")
        private List<DatabaseObject> excludeObjects;
        @JsonProperty(value="includeObjects")
        private List<DatabaseObject> includeObjects;
        @JsonProperty(value="vaultDetails")
        private CreateVaultDetails vaultDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder sourceDatabaseConnectionId(String sourceDatabaseConnectionId) {
            this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
            this.__explicitlySet__.add("sourceDatabaseConnectionId");
            return this;
        }

        public Builder sourceContainerDatabaseConnectionId(String sourceContainerDatabaseConnectionId) {
            this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
            this.__explicitlySet__.add("sourceContainerDatabaseConnectionId");
            return this;
        }

        public Builder targetDatabaseConnectionId(String targetDatabaseConnectionId) {
            this.targetDatabaseConnectionId = targetDatabaseConnectionId;
            this.__explicitlySet__.add("targetDatabaseConnectionId");
            return this;
        }

        public Builder excludeObjects(List<DatabaseObject> excludeObjects) {
            this.excludeObjects = excludeObjects;
            this.__explicitlySet__.add("excludeObjects");
            return this;
        }

        public Builder includeObjects(List<DatabaseObject> includeObjects) {
            this.includeObjects = includeObjects;
            this.__explicitlySet__.add("includeObjects");
            return this;
        }

        public Builder vaultDetails(CreateVaultDetails vaultDetails) {
            this.vaultDetails = vaultDetails;
            this.__explicitlySet__.add("vaultDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CloneMigrationDetails build() {
            CloneMigrationDetails model = new CloneMigrationDetails(this.displayName, this.compartmentId, this.agentId, this.sourceDatabaseConnectionId, this.sourceContainerDatabaseConnectionId, this.targetDatabaseConnectionId, this.excludeObjects, this.includeObjects, this.vaultDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloneMigrationDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseConnectionId")) {
                this.sourceDatabaseConnectionId(model.getSourceDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("sourceContainerDatabaseConnectionId")) {
                this.sourceContainerDatabaseConnectionId(model.getSourceContainerDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseConnectionId")) {
                this.targetDatabaseConnectionId(model.getTargetDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("excludeObjects")) {
                this.excludeObjects(model.getExcludeObjects());
            }
            if (model.wasPropertyExplicitlySet("includeObjects")) {
                this.includeObjects(model.getIncludeObjects());
            }
            if (model.wasPropertyExplicitlySet("vaultDetails")) {
                this.vaultDetails(model.getVaultDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

