/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemigration.DatabaseMigrationAsync;
import com.oracle.bmc.databasemigration.model.AdvisorReport;
import com.oracle.bmc.databasemigration.model.Agent;
import com.oracle.bmc.databasemigration.model.AgentCollection;
import com.oracle.bmc.databasemigration.model.AgentImageCollection;
import com.oracle.bmc.databasemigration.model.Connection;
import com.oracle.bmc.databasemigration.model.ConnectionCollection;
import com.oracle.bmc.databasemigration.model.ExcludedObjectSummaryCollection;
import com.oracle.bmc.databasemigration.model.Job;
import com.oracle.bmc.databasemigration.model.JobCollection;
import com.oracle.bmc.databasemigration.model.JobOutputSummaryCollection;
import com.oracle.bmc.databasemigration.model.Migration;
import com.oracle.bmc.databasemigration.model.MigrationCollection;
import com.oracle.bmc.databasemigration.model.MigrationObjectCollection;
import com.oracle.bmc.databasemigration.model.MigrationObjectTypeSummaryCollection;
import com.oracle.bmc.databasemigration.model.MigrationPhaseCollection;
import com.oracle.bmc.databasemigration.model.WorkRequest;
import com.oracle.bmc.databasemigration.model.WorkRequestCollection;
import com.oracle.bmc.databasemigration.model.WorkRequestErrorCollection;
import com.oracle.bmc.databasemigration.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.databasemigration.requests.AbortJobRequest;
import com.oracle.bmc.databasemigration.requests.AddMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.databasemigration.requests.ChangeConnectionCompartmentRequest;
import com.oracle.bmc.databasemigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.databasemigration.requests.CloneMigrationRequest;
import com.oracle.bmc.databasemigration.requests.CreateConnectionRequest;
import com.oracle.bmc.databasemigration.requests.CreateMigrationRequest;
import com.oracle.bmc.databasemigration.requests.DeleteAgentRequest;
import com.oracle.bmc.databasemigration.requests.DeleteConnectionRequest;
import com.oracle.bmc.databasemigration.requests.DeleteJobRequest;
import com.oracle.bmc.databasemigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.databasemigration.requests.EvaluateMigrationRequest;
import com.oracle.bmc.databasemigration.requests.GetAdvisorReportRequest;
import com.oracle.bmc.databasemigration.requests.GetAgentRequest;
import com.oracle.bmc.databasemigration.requests.GetConnectionRequest;
import com.oracle.bmc.databasemigration.requests.GetJobOutputContentRequest;
import com.oracle.bmc.databasemigration.requests.GetJobRequest;
import com.oracle.bmc.databasemigration.requests.GetMigrationRequest;
import com.oracle.bmc.databasemigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemigration.requests.ListAgentImagesRequest;
import com.oracle.bmc.databasemigration.requests.ListAgentsRequest;
import com.oracle.bmc.databasemigration.requests.ListConnectionsRequest;
import com.oracle.bmc.databasemigration.requests.ListExcludedObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobOutputsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobsRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationObjectTypesRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasemigration.requests.RemoveMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ResumeJobRequest;
import com.oracle.bmc.databasemigration.requests.RetrieveSupportedPhasesRequest;
import com.oracle.bmc.databasemigration.requests.StartMigrationRequest;
import com.oracle.bmc.databasemigration.requests.UpdateAgentRequest;
import com.oracle.bmc.databasemigration.requests.UpdateConnectionRequest;
import com.oracle.bmc.databasemigration.requests.UpdateJobRequest;
import com.oracle.bmc.databasemigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.databasemigration.responses.AbortJobResponse;
import com.oracle.bmc.databasemigration.responses.AddMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.databasemigration.responses.ChangeConnectionCompartmentResponse;
import com.oracle.bmc.databasemigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.databasemigration.responses.CloneMigrationResponse;
import com.oracle.bmc.databasemigration.responses.CreateConnectionResponse;
import com.oracle.bmc.databasemigration.responses.CreateMigrationResponse;
import com.oracle.bmc.databasemigration.responses.DeleteAgentResponse;
import com.oracle.bmc.databasemigration.responses.DeleteConnectionResponse;
import com.oracle.bmc.databasemigration.responses.DeleteJobResponse;
import com.oracle.bmc.databasemigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.databasemigration.responses.EvaluateMigrationResponse;
import com.oracle.bmc.databasemigration.responses.GetAdvisorReportResponse;
import com.oracle.bmc.databasemigration.responses.GetAgentResponse;
import com.oracle.bmc.databasemigration.responses.GetConnectionResponse;
import com.oracle.bmc.databasemigration.responses.GetJobOutputContentResponse;
import com.oracle.bmc.databasemigration.responses.GetJobResponse;
import com.oracle.bmc.databasemigration.responses.GetMigrationResponse;
import com.oracle.bmc.databasemigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.databasemigration.responses.ListAgentImagesResponse;
import com.oracle.bmc.databasemigration.responses.ListAgentsResponse;
import com.oracle.bmc.databasemigration.responses.ListConnectionsResponse;
import com.oracle.bmc.databasemigration.responses.ListExcludedObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobOutputsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobsResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationObjectTypesResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.databasemigration.responses.RemoveMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ResumeJobResponse;
import com.oracle.bmc.databasemigration.responses.RetrieveSupportedPhasesResponse;
import com.oracle.bmc.databasemigration.responses.StartMigrationResponse;
import com.oracle.bmc.databasemigration.responses.UpdateAgentResponse;
import com.oracle.bmc.databasemigration.responses.UpdateConnectionResponse;
import com.oracle.bmc.databasemigration.responses.UpdateJobResponse;
import com.oracle.bmc.databasemigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrationAsyncClient
extends BaseAsyncClient
implements DatabaseMigrationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASEMIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://odms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseMigrationAsyncClient.class);

    private DatabaseMigrationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AbortJobResponse> abortJob(AbortJobRequest request, AsyncHandler<AbortJobRequest, AbortJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, AbortJobResponse::builder).logger(LOG, "abortJob").serviceDetails("DatabaseMigration", "AbortJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/AbortJob").method(Method.POST).requestBuilder(AbortJobRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("abort").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, AbortJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", AbortJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AbortJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AddMigrationObjectsResponse> addMigrationObjects(AddMigrationObjectsRequest request, AsyncHandler<AddMigrationObjectsRequest, AddMigrationObjectsResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddMigrationObjectsDetails(), "addMigrationObjectsDetails is required");
        return this.clientCall(request, AddMigrationObjectsResponse::builder).logger(LOG, "addMigrationObjects").serviceDetails("DatabaseMigration", "AddMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/AddMigrationObjects").method(Method.POST).requestBuilder(AddMigrationObjectsRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("addMigrationObjects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AddMigrationObjectsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAgentCompartmentResponse> changeAgentCompartment(ChangeAgentCompartmentRequest request, AsyncHandler<ChangeAgentCompartmentRequest, ChangeAgentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentCompartmentDetails(), "changeAgentCompartmentDetails is required");
        return this.clientCall(request, ChangeAgentCompartmentResponse::builder).logger(LOG, "changeAgentCompartment").serviceDetails("DatabaseMigration", "ChangeAgentCompartment", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Agent/ChangeAgentCompartment").method(Method.POST).requestBuilder(ChangeAgentCompartmentRequest::builder).basePath("/20210929").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAgentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeConnectionCompartmentResponse> changeConnectionCompartment(ChangeConnectionCompartmentRequest request, AsyncHandler<ChangeConnectionCompartmentRequest, ChangeConnectionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectionCompartmentDetails(), "changeConnectionCompartmentDetails is required");
        return this.clientCall(request, ChangeConnectionCompartmentResponse::builder).logger(LOG, "changeConnectionCompartment").serviceDetails("DatabaseMigration", "ChangeConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Connection/ChangeConnectionCompartment").method(Method.POST).requestBuilder(ChangeConnectionCompartmentRequest::builder).basePath("/20210929").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeConnectionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeMigrationCompartmentResponse> changeMigrationCompartment(ChangeMigrationCompartmentRequest request, AsyncHandler<ChangeMigrationCompartmentRequest, ChangeMigrationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMigrationCompartmentDetails(), "changeMigrationCompartmentDetails is required");
        return this.clientCall(request, ChangeMigrationCompartmentResponse::builder).logger(LOG, "changeMigrationCompartment").serviceDetails("DatabaseMigration", "ChangeMigrationCompartment", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/ChangeMigrationCompartment").method(Method.POST).requestBuilder(ChangeMigrationCompartmentRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeMigrationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CloneMigrationResponse> cloneMigration(CloneMigrationRequest request, AsyncHandler<CloneMigrationRequest, CloneMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneMigrationDetails(), "cloneMigrationDetails is required");
        return this.clientCall(request, CloneMigrationResponse::builder).logger(LOG, "cloneMigration").serviceDetails("DatabaseMigration", "CloneMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/CloneMigration").method(Method.POST).requestBuilder(CloneMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("clone").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Migration.class, CloneMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", CloneMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CloneMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CloneMigrationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("DatabaseMigration", "CreateConnection", "").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20210929").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateMigrationResponse> createMigration(CreateMigrationRequest request, AsyncHandler<CreateMigrationRequest, CreateMigrationResponse> handler) {
        Objects.requireNonNull(request.getCreateMigrationDetails(), "createMigrationDetails is required");
        return this.clientCall(request, CreateMigrationResponse::builder).logger(LOG, "createMigration").serviceDetails("DatabaseMigration", "CreateMigration", "").method(Method.POST).requestBuilder(CreateMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Migration.class, CreateMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", CreateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateMigrationResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateMigrationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAgentResponse> deleteAgent(DeleteAgentRequest request, AsyncHandler<DeleteAgentRequest, DeleteAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAgentResponse::builder).logger(LOG, "deleteAgent").serviceDetails("DatabaseMigration", "DeleteAgent", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Agent/DeleteAgent").method(Method.DELETE).requestBuilder(DeleteAgentRequest::builder).basePath("/20210929").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteAgentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAgentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("DatabaseMigration", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20210929").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteJobResponse> deleteJob(DeleteJobRequest request, AsyncHandler<DeleteJobRequest, DeleteJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DatabaseMigration", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMigrationResponse> deleteMigration(DeleteMigrationRequest request, AsyncHandler<DeleteMigrationRequest, DeleteMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMigrationResponse::builder).logger(LOG, "deleteMigration").serviceDetails("DatabaseMigration", "DeleteMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/DeleteMigration").method(Method.DELETE).requestBuilder(DeleteMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteMigrationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EvaluateMigrationResponse> evaluateMigration(EvaluateMigrationRequest request, AsyncHandler<EvaluateMigrationRequest, EvaluateMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, EvaluateMigrationResponse::builder).logger(LOG, "evaluateMigration").serviceDetails("DatabaseMigration", "EvaluateMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/EvaluateMigration").method(Method.POST).requestBuilder(EvaluateMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, EvaluateMigrationResponse.Builder::job).handleResponseHeaderString("opc-request-id", EvaluateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EvaluateMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", EvaluateMigrationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetAdvisorReportResponse> getAdvisorReport(GetAdvisorReportRequest request, AsyncHandler<GetAdvisorReportRequest, GetAdvisorReportResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAdvisorReportResponse::builder).logger(LOG, "getAdvisorReport").serviceDetails("DatabaseMigration", "GetAdvisorReport", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/GetAdvisorReport").method(Method.GET).requestBuilder(GetAdvisorReportRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("advisorReport").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AdvisorReport.class, GetAdvisorReportResponse.Builder::advisorReport).handleResponseHeaderString("opc-request-id", GetAdvisorReportResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAdvisorReportResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetAgentResponse> getAgent(GetAgentRequest request, AsyncHandler<GetAgentRequest, GetAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAgentResponse::builder).logger(LOG, "getAgent").serviceDetails("DatabaseMigration", "GetAgent", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Agent/GetAgent").method(Method.GET).requestBuilder(GetAgentRequest::builder).basePath("/20210929").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Agent.class, GetAgentResponse.Builder::agent).handleResponseHeaderString("opc-request-id", GetAgentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAgentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("DatabaseMigration", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20210929").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DatabaseMigration", "GetJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetJobOutputContentResponse> getJobOutputContent(GetJobOutputContentRequest request, AsyncHandler<GetJobOutputContentRequest, GetJobOutputContentResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobOutputContentResponse::builder).logger(LOG, "getJobOutputContent").serviceDetails("DatabaseMigration", "GetJobOutputContent", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/GetJobOutputContent").method(Method.GET).requestBuilder(GetJobOutputContentRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetJobOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetJobOutputContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMigrationResponse> getMigration(GetMigrationRequest request, AsyncHandler<GetMigrationRequest, GetMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMigrationResponse::builder).logger(LOG, "getMigration").serviceDetails("DatabaseMigration", "GetMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/GetMigration").method(Method.GET).requestBuilder(GetMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Migration.class, GetMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", GetMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetMigrationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DatabaseMigration", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210929").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAgentImagesResponse> listAgentImages(ListAgentImagesRequest request, AsyncHandler<ListAgentImagesRequest, ListAgentImagesResponse> handler) {
        return this.clientCall(request, ListAgentImagesResponse::builder).logger(LOG, "listAgentImages").serviceDetails("DatabaseMigration", "ListAgentImages", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/AgentImageSummary/ListAgentImages").method(Method.GET).requestBuilder(ListAgentImagesRequest::builder).basePath("/20210929").appendPathParam("agentImages").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentImageCollection.class, ListAgentImagesResponse.Builder::agentImageCollection).handleResponseHeaderString("opc-request-id", ListAgentImagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentImagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAgentsResponse> listAgents(ListAgentsRequest request, AsyncHandler<ListAgentsRequest, ListAgentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAgentsResponse::builder).logger(LOG, "listAgents").serviceDetails("DatabaseMigration", "ListAgents", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/AgentSummary/ListAgents").method(Method.GET).requestBuilder(ListAgentsRequest::builder).basePath("/20210929").appendPathParam("agents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentCollection.class, ListAgentsResponse.Builder::agentCollection).handleResponseHeaderString("opc-request-id", ListAgentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("DatabaseMigration", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/ConnectionSummary/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20210929").appendPathParam("connections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExcludedObjectsResponse> listExcludedObjects(ListExcludedObjectsRequest request, AsyncHandler<ListExcludedObjectsRequest, ListExcludedObjectsResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExcludedObjectsResponse::builder).logger(LOG, "listExcludedObjects").serviceDetails("DatabaseMigration", "ListExcludedObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/ExcludedObjectSummary/ListExcludedObjects").method(Method.GET).requestBuilder(ListExcludedObjectsRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("excludedObjects").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("type", (Object)request.getType()).appendQueryParam("owner", (Object)request.getOwner()).appendQueryParam("object", (Object)request.getObject()).appendQueryParam("ownerContains", (Object)request.getOwnerContains()).appendQueryParam("objectContains", (Object)request.getObjectContains()).appendEnumQueryParam("reasonCategory", (BmcEnum)request.getReasonCategory()).appendQueryParam("sourceRule", (Object)request.getSourceRule()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExcludedObjectSummaryCollection.class, ListExcludedObjectsResponse.Builder::excludedObjectSummaryCollection).handleResponseHeaderString("opc-request-id", ListExcludedObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExcludedObjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListJobOutputsResponse> listJobOutputs(ListJobOutputsRequest request, AsyncHandler<ListJobOutputsRequest, ListJobOutputsResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListJobOutputsResponse::builder).logger(LOG, "listJobOutputs").serviceDetails("DatabaseMigration", "ListJobOutputs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/JobOutputSummary/ListJobOutputs").method(Method.GET).requestBuilder(ListJobOutputsRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("output").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobOutputSummaryCollection.class, ListJobOutputsResponse.Builder::jobOutputSummaryCollection).handleResponseHeaderString("opc-request-id", ListJobOutputsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobOutputsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        Objects.requireNonNull(request.getMigrationId(), "migrationId is required");
        return this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DatabaseMigration", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/JobSummary/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20210929").appendPathParam("jobs").appendQueryParam("migrationId", (Object)request.getMigrationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobCollection.class, ListJobsResponse.Builder::jobCollection).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMigrationObjectTypesResponse> listMigrationObjectTypes(ListMigrationObjectTypesRequest request, AsyncHandler<ListMigrationObjectTypesRequest, ListMigrationObjectTypesResponse> handler) {
        return this.clientCall(request, ListMigrationObjectTypesResponse::builder).logger(LOG, "listMigrationObjectTypes").serviceDetails("DatabaseMigration", "ListMigrationObjectTypes", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/MigrationObjectTypeSummary/ListMigrationObjectTypes").method(Method.GET).requestBuilder(ListMigrationObjectTypesRequest::builder).basePath("/20210929").appendPathParam("migrationObjectTypes").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationObjectTypeSummaryCollection.class, ListMigrationObjectTypesResponse.Builder::migrationObjectTypeSummaryCollection).handleResponseHeaderString("opc-request-id", ListMigrationObjectTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationObjectTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMigrationObjectsResponse> listMigrationObjects(ListMigrationObjectsRequest request, AsyncHandler<ListMigrationObjectsRequest, ListMigrationObjectsResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListMigrationObjectsResponse::builder).logger(LOG, "listMigrationObjects").serviceDetails("DatabaseMigration", "ListMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/MigrationObjectCollection/ListMigrationObjects").method(Method.GET).requestBuilder(ListMigrationObjectsRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("migrationObjects").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(MigrationObjectCollection.class, ListMigrationObjectsResponse.Builder::migrationObjectCollection).handleResponseHeaderString("opc-request-id", ListMigrationObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationObjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMigrationsResponse> listMigrations(ListMigrationsRequest request, AsyncHandler<ListMigrationsRequest, ListMigrationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListMigrationsResponse::builder).logger(LOG, "listMigrations").serviceDetails("DatabaseMigration", "ListMigrations", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/MigrationSummary/ListMigrations").method(Method.GET).requestBuilder(ListMigrationsRequest::builder).basePath("/20210929").appendPathParam("migrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleDetails", (BmcEnum)request.getLifecycleDetails()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationCollection.class, ListMigrationsResponse.Builder::migrationCollection).handleResponseHeaderString("opc-request-id", ListMigrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DatabaseMigration", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210929").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DatabaseMigration", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210929").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DatabaseMigration", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210929").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveMigrationObjectsResponse> removeMigrationObjects(RemoveMigrationObjectsRequest request, AsyncHandler<RemoveMigrationObjectsRequest, RemoveMigrationObjectsResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveMigrationObjectsDetails(), "removeMigrationObjectsDetails is required");
        return this.clientCall(request, RemoveMigrationObjectsResponse::builder).logger(LOG, "removeMigrationObjects").serviceDetails("DatabaseMigration", "RemoveMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/RemoveMigrationObjects").method(Method.POST).requestBuilder(RemoveMigrationObjectsRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("removeMigrationObjects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", RemoveMigrationObjectsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResumeJobResponse> resumeJob(ResumeJobRequest request, AsyncHandler<ResumeJobRequest, ResumeJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResumeJobResponse::builder).logger(LOG, "resumeJob").serviceDetails("DatabaseMigration", "ResumeJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/ResumeJob").method(Method.POST).requestBuilder(ResumeJobRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Job.class, ResumeJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", ResumeJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ResumeJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RetrieveSupportedPhasesResponse> retrieveSupportedPhases(RetrieveSupportedPhasesRequest request, AsyncHandler<RetrieveSupportedPhasesRequest, RetrieveSupportedPhasesResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetrieveSupportedPhasesResponse::builder).logger(LOG, "retrieveSupportedPhases").serviceDetails("DatabaseMigration", "RetrieveSupportedPhases", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/RetrieveSupportedPhases").method(Method.POST).requestBuilder(RetrieveSupportedPhasesRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("getSupportedPhases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationPhaseCollection.class, RetrieveSupportedPhasesResponse.Builder::migrationPhaseCollection).handleResponseHeaderString("opc-request-id", RetrieveSupportedPhasesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartMigrationResponse> startMigration(StartMigrationRequest request, AsyncHandler<StartMigrationRequest, StartMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartMigrationResponse::builder).logger(LOG, "startMigration").serviceDetails("DatabaseMigration", "StartMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/StartMigration").method(Method.POST).requestBuilder(StartMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Job.class, StartMigrationResponse.Builder::job).handleResponseHeaderString("opc-request-id", StartMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", StartMigrationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateAgentResponse> updateAgent(UpdateAgentRequest request, AsyncHandler<UpdateAgentRequest, UpdateAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDetails(), "updateAgentDetails is required");
        return this.clientCall(request, UpdateAgentResponse::builder).logger(LOG, "updateAgent").serviceDetails("DatabaseMigration", "UpdateAgent", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Agent/UpdateAgent").method(Method.PUT).requestBuilder(UpdateAgentRequest::builder).basePath("/20210929").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Agent.class, UpdateAgentResponse.Builder::agent).handleResponseHeaderString("opc-request-id", UpdateAgentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAgentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("DatabaseMigration", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20210929").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DatabaseMigration", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20210929").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateMigrationResponse> updateMigration(UpdateMigrationRequest request, AsyncHandler<UpdateMigrationRequest, UpdateMigrationResponse> handler) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationDetails(), "updateMigrationDetails is required");
        return this.clientCall(request, UpdateMigrationResponse::builder).logger(LOG, "updateMigration").serviceDetails("DatabaseMigration", "UpdateMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20210929/Migration/UpdateMigration").method(Method.PUT).requestBuilder(UpdateMigrationRequest::builder).basePath("/20210929").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateMigrationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DatabaseMigrationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DatabaseMigrationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DatabaseMigrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DatabaseMigrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DatabaseMigrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DatabaseMigrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseMigrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseMigrationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DatabaseMigrationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DatabaseMigrationAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

