/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExecutionPlanStatsComparisionRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Long sqlTuningAdvisorTaskId;
    private Long sqlObjectId;
    private Long executionId;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public Long getSqlObjectId() {
        return this.sqlObjectId;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningAdvisorTaskId(this.sqlTuningAdvisorTaskId).sqlObjectId(this.sqlObjectId).executionId(this.executionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(",sqlObjectId=").append(String.valueOf(this.sqlObjectId));
        sb.append(",executionId=").append(String.valueOf(this.executionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExecutionPlanStatsComparisionRequest)) {
            return false;
        }
        GetExecutionPlanStatsComparisionRequest other = (GetExecutionPlanStatsComparisionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals(this.sqlObjectId, other.sqlObjectId) && Objects.equals(this.executionId, other.executionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.sqlObjectId == null ? 43 : this.sqlObjectId.hashCode());
        result = result * 59 + (this.executionId == null ? 43 : this.executionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExecutionPlanStatsComparisionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Long sqlTuningAdvisorTaskId = null;
        private Long sqlObjectId = null;
        private Long executionId = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            return this;
        }

        public Builder sqlObjectId(Long sqlObjectId) {
            this.sqlObjectId = sqlObjectId;
            return this;
        }

        public Builder executionId(Long executionId) {
            this.executionId = executionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExecutionPlanStatsComparisionRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningAdvisorTaskId(o.getSqlTuningAdvisorTaskId());
            this.sqlObjectId(o.getSqlObjectId());
            this.executionId(o.getExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExecutionPlanStatsComparisionRequest build() {
            GetExecutionPlanStatsComparisionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExecutionPlanStatsComparisionRequest buildWithoutInvocationCallback() {
            GetExecutionPlanStatsComparisionRequest request = new GetExecutionPlanStatsComparisionRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningAdvisorTaskId = this.sqlTuningAdvisorTaskId;
            request.sqlObjectId = this.sqlObjectId;
            request.executionId = this.executionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

