/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobRun
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="jobId")
    private final String jobId;
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="managedDatabaseGroupId")
    private final String managedDatabaseGroupId;
    @JsonProperty(value="managedDatabaseId")
    private final String managedDatabaseId;
    @JsonProperty(value="runStatus")
    private final RunStatus runStatus;
    @JsonProperty(value="timeSubmitted")
    private final Date timeSubmitted;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "compartmentId", "jobId", "jobName", "managedDatabaseGroupId", "managedDatabaseId", "runStatus", "timeSubmitted", "timeUpdated"})
    public JobRun(String id, String name, String compartmentId, String jobId, String jobName, String managedDatabaseGroupId, String managedDatabaseId, RunStatus runStatus, Date timeSubmitted, Date timeUpdated) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.jobId = jobId;
        this.jobName = jobName;
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.managedDatabaseId = managedDatabaseId;
        this.runStatus = runStatus;
        this.timeSubmitted = timeSubmitted;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public RunStatus getRunStatus() {
        return this.runStatus;
    }

    public Date getTimeSubmitted() {
        return this.timeSubmitted;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobRun(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(", jobName=").append(String.valueOf(this.jobName));
        sb.append(", managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(", managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(", runStatus=").append(String.valueOf((Object)this.runStatus));
        sb.append(", timeSubmitted=").append(String.valueOf(this.timeSubmitted));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.jobName, other.jobName) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.runStatus, (Object)other.runStatus) && Objects.equals(this.timeSubmitted, other.timeSubmitted) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.runStatus == null ? 43 : this.runStatus.hashCode());
        result = result * 59 + (this.timeSubmitted == null ? 43 : this.timeSubmitted.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RunStatus implements BmcEnum
    {
        Completed("COMPLETED"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RunStatus> map;

        private RunStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RunStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RunStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RunStatus.class);
            map = new HashMap<String, RunStatus>();
            for (RunStatus v : RunStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="jobId")
        private String jobId;
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="managedDatabaseGroupId")
        private String managedDatabaseGroupId;
        @JsonProperty(value="managedDatabaseId")
        private String managedDatabaseId;
        @JsonProperty(value="runStatus")
        private RunStatus runStatus;
        @JsonProperty(value="timeSubmitted")
        private Date timeSubmitted;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            this.__explicitlySet__.add("managedDatabaseGroupId");
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            this.__explicitlySet__.add("managedDatabaseId");
            return this;
        }

        public Builder runStatus(RunStatus runStatus) {
            this.runStatus = runStatus;
            this.__explicitlySet__.add("runStatus");
            return this;
        }

        public Builder timeSubmitted(Date timeSubmitted) {
            this.timeSubmitted = timeSubmitted;
            this.__explicitlySet__.add("timeSubmitted");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public JobRun build() {
            JobRun model = new JobRun(this.id, this.name, this.compartmentId, this.jobId, this.jobName, this.managedDatabaseGroupId, this.managedDatabaseId, this.runStatus, this.timeSubmitted, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobRun model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseGroupId")) {
                this.managedDatabaseGroupId(model.getManagedDatabaseGroupId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseId")) {
                this.managedDatabaseId(model.getManagedDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("runStatus")) {
                this.runStatus(model.getRunStatus());
            }
            if (model.wasPropertyExplicitlySet("timeSubmitted")) {
                this.timeSubmitted(model.getTimeSubmitted());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

