/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.SqlTuningAsync;
import com.oracle.bmc.databasemanagement.model.ExecutionPlanStatsComparision;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskFindingCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskRecommendationCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskSqlExecutionPlan;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskSummaryReport;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningTaskReturn;
import com.oracle.bmc.databasemanagement.requests.CloneSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.GetExecutionPlanStatsComparisionRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlExecutionPlanRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlTuningAdvisorTaskSummaryReportRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskFindingsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskRecommendationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTasksRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningSetsRequest;
import com.oracle.bmc.databasemanagement.requests.StartSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.responses.CloneSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.GetExecutionPlanStatsComparisionResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlExecutionPlanResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlTuningAdvisorTaskSummaryReportResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskFindingsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskRecommendationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTasksResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningSetsResponse;
import com.oracle.bmc.databasemanagement.responses.StartSqlTuningTaskResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTuningAsyncClient
extends BaseAsyncClient
implements SqlTuningAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SQLTUNING").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SqlTuningAsyncClient.class);

    private SqlTuningAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CloneSqlTuningTaskResponse> cloneSqlTuningTask(CloneSqlTuningTaskRequest request, AsyncHandler<CloneSqlTuningTaskRequest, CloneSqlTuningTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneSqlTuningTaskDetails(), "cloneSqlTuningTaskDetails is required");
        return this.clientCall(request, CloneSqlTuningTaskResponse::builder).logger(LOG, "cloneSqlTuningTask").serviceDetails("SqlTuning", "CloneSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/CloneSqlTuningTask").method(Method.POST).requestBuilder(CloneSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("cloneSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningTaskReturn.class, CloneSqlTuningTaskResponse.Builder::sqlTuningTaskReturn).handleResponseHeaderString("opc-request-id", CloneSqlTuningTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DropSqlTuningTaskResponse> dropSqlTuningTask(DropSqlTuningTaskRequest request, AsyncHandler<DropSqlTuningTaskRequest, DropSqlTuningTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropSqlTuningTaskDetails(), "dropSqlTuningTaskDetails is required");
        return this.clientCall(request, DropSqlTuningTaskResponse::builder).logger(LOG, "dropSqlTuningTask").serviceDetails("SqlTuning", "DropSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DropSqlTuningTask").method(Method.POST).requestBuilder(DropSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("dropSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DropSqlTuningTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExecutionPlanStatsComparisionResponse> getExecutionPlanStatsComparision(GetExecutionPlanStatsComparisionRequest request, AsyncHandler<GetExecutionPlanStatsComparisionRequest, GetExecutionPlanStatsComparisionResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getExecutionId(), "executionId is required");
        return this.clientCall(request, GetExecutionPlanStatsComparisionResponse::builder).logger(LOG, "getExecutionPlanStatsComparision").serviceDetails("SqlTuning", "GetExecutionPlanStatsComparision", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetExecutionPlanStatsComparision").method(Method.GET).requestBuilder(GetExecutionPlanStatsComparisionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("executionPlanStatsComparision").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendQueryParam("executionId", (Object)request.getExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExecutionPlanStatsComparision.class, GetExecutionPlanStatsComparisionResponse.Builder::executionPlanStatsComparision).handleResponseHeaderString("opc-request-id", GetExecutionPlanStatsComparisionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSqlExecutionPlanResponse> getSqlExecutionPlan(GetSqlExecutionPlanRequest request, AsyncHandler<GetSqlExecutionPlanRequest, GetSqlExecutionPlanResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getAttribute(), "attribute is required");
        return this.clientCall(request, GetSqlExecutionPlanResponse::builder).logger(LOG, "getSqlExecutionPlan").serviceDetails("SqlTuning", "GetSqlExecutionPlan", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlExecutionPlan").method(Method.GET).requestBuilder(GetSqlExecutionPlanRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("sqlExecutionPlan").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendEnumQueryParam("attribute", (BmcEnum)request.getAttribute()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskSqlExecutionPlan.class, GetSqlExecutionPlanResponse.Builder::sqlTuningAdvisorTaskSqlExecutionPlan).handleResponseHeaderString("opc-request-id", GetSqlExecutionPlanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSqlTuningAdvisorTaskSummaryReportResponse> getSqlTuningAdvisorTaskSummaryReport(GetSqlTuningAdvisorTaskSummaryReportRequest request, AsyncHandler<GetSqlTuningAdvisorTaskSummaryReportRequest, GetSqlTuningAdvisorTaskSummaryReportResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSqlTuningAdvisorTaskSummaryReportResponse::builder).logger(LOG, "getSqlTuningAdvisorTaskSummaryReport").serviceDetails("SqlTuning", "GetSqlTuningAdvisorTaskSummaryReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlTuningAdvisorTaskSummaryReport").method(Method.GET).requestBuilder(GetSqlTuningAdvisorTaskSummaryReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("summaryReport").appendEnumQueryParam("searchPeriod", (BmcEnum)request.getSearchPeriod()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("beginExecIdGreaterThanOrEqualTo", (Object)request.getBeginExecIdGreaterThanOrEqualTo()).appendQueryParam("endExecIdLessThanOrEqualTo", (Object)request.getEndExecIdLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskSummaryReport.class, GetSqlTuningAdvisorTaskSummaryReportResponse.Builder::sqlTuningAdvisorTaskSummaryReport).handleResponseHeaderString("opc-request-id", GetSqlTuningAdvisorTaskSummaryReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSqlTuningAdvisorTaskFindingsResponse> listSqlTuningAdvisorTaskFindings(ListSqlTuningAdvisorTaskFindingsRequest request, AsyncHandler<ListSqlTuningAdvisorTaskFindingsRequest, ListSqlTuningAdvisorTaskFindingsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSqlTuningAdvisorTaskFindingsResponse::builder).logger(LOG, "listSqlTuningAdvisorTaskFindings").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTaskFindings", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTaskFindings").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTaskFindingsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("findings").appendQueryParam("beginExecId", (Object)request.getBeginExecId()).appendQueryParam("endExecId", (Object)request.getEndExecId()).appendEnumQueryParam("searchPeriod", (BmcEnum)request.getSearchPeriod()).appendEnumQueryParam("findingFilter", (BmcEnum)request.getFindingFilter()).appendQueryParam("statsHashFilter", (Object)request.getStatsHashFilter()).appendQueryParam("indexHashFilter", (Object)request.getIndexHashFilter()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskFindingCollection.class, ListSqlTuningAdvisorTaskFindingsResponse.Builder::sqlTuningAdvisorTaskFindingCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTaskFindingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTaskFindingsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSqlTuningAdvisorTaskRecommendationsResponse> listSqlTuningAdvisorTaskRecommendations(ListSqlTuningAdvisorTaskRecommendationsRequest request, AsyncHandler<ListSqlTuningAdvisorTaskRecommendationsRequest, ListSqlTuningAdvisorTaskRecommendationsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getExecutionId(), "executionId is required");
        return this.clientCall(request, ListSqlTuningAdvisorTaskRecommendationsResponse::builder).logger(LOG, "listSqlTuningAdvisorTaskRecommendations").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTaskRecommendations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTaskRecommendations").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTaskRecommendationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("recommendations").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendQueryParam("executionId", (Object)request.getExecutionId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskRecommendationCollection.class, ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::sqlTuningAdvisorTaskRecommendationCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSqlTuningAdvisorTasksResponse> listSqlTuningAdvisorTasks(ListSqlTuningAdvisorTasksRequest request, AsyncHandler<ListSqlTuningAdvisorTasksRequest, ListSqlTuningAdvisorTasksResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSqlTuningAdvisorTasksResponse::builder).logger(LOG, "listSqlTuningAdvisorTasks").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTasks", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTasks").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTasksRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskCollection.class, ListSqlTuningAdvisorTasksResponse.Builder::sqlTuningAdvisorTaskCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTasksResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSqlTuningSetsResponse> listSqlTuningSets(ListSqlTuningSetsRequest request, AsyncHandler<ListSqlTuningSetsRequest, ListSqlTuningSetsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSqlTuningSetsResponse::builder).logger(LOG, "listSqlTuningSets").serviceDetails("SqlTuning", "ListSqlTuningSets", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningSets").method(Method.GET).requestBuilder(ListSqlTuningSetsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendQueryParam("owner", (Object)request.getOwner()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningSetCollection.class, ListSqlTuningSetsResponse.Builder::sqlTuningSetCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningSetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningSetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<StartSqlTuningTaskResponse> startSqlTuningTask(StartSqlTuningTaskRequest request, AsyncHandler<StartSqlTuningTaskRequest, StartSqlTuningTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartSqlTuningTaskDetails(), "startSqlTuningTaskDetails is required");
        return this.clientCall(request, StartSqlTuningTaskResponse::builder).logger(LOG, "startSqlTuningTask").serviceDetails("SqlTuning", "StartSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/StartSqlTuningTask").method(Method.POST).requestBuilder(StartSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("startSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningTaskReturn.class, StartSqlTuningTaskResponse.Builder::sqlTuningTaskReturn).handleResponseHeaderString("opc-request-id", StartSqlTuningTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public SqlTuningAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SqlTuningAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SqlTuningAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SqlTuningAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SqlTuningAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SqlTuningAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SqlTuningAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SqlTuningAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SqlTuningAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SqlTuningAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SqlTuningAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

