/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDashboardGroupRequest
extends BmcRequest<Void> {
    private String dashboardGroupId;
    private String opcRequestId;
    private String opcCrossRegion;

    public String getDashboardGroupId() {
        return this.dashboardGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcCrossRegion() {
        return this.opcCrossRegion;
    }

    public Builder toBuilder() {
        return new Builder().dashboardGroupId(this.dashboardGroupId).opcRequestId(this.opcRequestId).opcCrossRegion(this.opcCrossRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dashboardGroupId=").append(String.valueOf(this.dashboardGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcCrossRegion=").append(String.valueOf(this.opcCrossRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDashboardGroupRequest)) {
            return false;
        }
        GetDashboardGroupRequest other = (GetDashboardGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dashboardGroupId, other.dashboardGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcCrossRegion, other.opcCrossRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dashboardGroupId == null ? 43 : this.dashboardGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcCrossRegion == null ? 43 : this.opcCrossRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDashboardGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dashboardGroupId = null;
        private String opcRequestId = null;
        private String opcCrossRegion = null;

        public Builder dashboardGroupId(String dashboardGroupId) {
            this.dashboardGroupId = dashboardGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcCrossRegion(String opcCrossRegion) {
            this.opcCrossRegion = opcCrossRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDashboardGroupRequest o) {
            this.dashboardGroupId(o.getDashboardGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcCrossRegion(o.getOpcCrossRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDashboardGroupRequest build() {
            GetDashboardGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDashboardGroupRequest buildWithoutInvocationCallback() {
            GetDashboardGroupRequest request = new GetDashboardGroupRequest();
            request.dashboardGroupId = this.dashboardGroupId;
            request.opcRequestId = this.opcRequestId;
            request.opcCrossRegion = this.opcCrossRegion;
            return request;
        }
    }
}

