/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ContainerHealthCheckFailureAction;
import com.oracle.bmc.containerinstances.model.CreateContainerHealthCheckDetails;
import com.oracle.bmc.containerinstances.model.HealthCheckHttpHeader;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="healthCheckType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateContainerHttpHealthCheckDetails
extends CreateContainerHealthCheckDetails {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="headers")
    private final List<HealthCheckHttpHeader> headers;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateContainerHttpHealthCheckDetails(String name, Integer initialDelayInSeconds, Integer intervalInSeconds, Integer failureThreshold, Integer successThreshold, Integer timeoutInSeconds, ContainerHealthCheckFailureAction failureAction, String path, Integer port, List<HealthCheckHttpHeader> headers) {
        super(name, initialDelayInSeconds, intervalInSeconds, failureThreshold, successThreshold, timeoutInSeconds, failureAction);
        this.path = path;
        this.port = port;
        this.headers = headers;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getPort() {
        return this.port;
    }

    public List<HealthCheckHttpHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateContainerHttpHealthCheckDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateContainerHttpHealthCheckDetails)) {
            return false;
        }
        CreateContainerHttpHealthCheckDetails other = (CreateContainerHttpHealthCheckDetails)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals(this.port, other.port) && Objects.equals(this.headers, other.headers) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="initialDelayInSeconds")
        private Integer initialDelayInSeconds;
        @JsonProperty(value="intervalInSeconds")
        private Integer intervalInSeconds;
        @JsonProperty(value="failureThreshold")
        private Integer failureThreshold;
        @JsonProperty(value="successThreshold")
        private Integer successThreshold;
        @JsonProperty(value="timeoutInSeconds")
        private Integer timeoutInSeconds;
        @JsonProperty(value="failureAction")
        private ContainerHealthCheckFailureAction failureAction;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="headers")
        private List<HealthCheckHttpHeader> headers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder initialDelayInSeconds(Integer initialDelayInSeconds) {
            this.initialDelayInSeconds = initialDelayInSeconds;
            this.__explicitlySet__.add("initialDelayInSeconds");
            return this;
        }

        public Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            this.__explicitlySet__.add("intervalInSeconds");
            return this;
        }

        public Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            this.__explicitlySet__.add("failureThreshold");
            return this;
        }

        public Builder successThreshold(Integer successThreshold) {
            this.successThreshold = successThreshold;
            this.__explicitlySet__.add("successThreshold");
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            this.__explicitlySet__.add("timeoutInSeconds");
            return this;
        }

        public Builder failureAction(ContainerHealthCheckFailureAction failureAction) {
            this.failureAction = failureAction;
            this.__explicitlySet__.add("failureAction");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder headers(List<HealthCheckHttpHeader> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public CreateContainerHttpHealthCheckDetails build() {
            CreateContainerHttpHealthCheckDetails model = new CreateContainerHttpHealthCheckDetails(this.name, this.initialDelayInSeconds, this.intervalInSeconds, this.failureThreshold, this.successThreshold, this.timeoutInSeconds, this.failureAction, this.path, this.port, this.headers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateContainerHttpHealthCheckDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("initialDelayInSeconds")) {
                this.initialDelayInSeconds(model.getInitialDelayInSeconds());
            }
            if (model.wasPropertyExplicitlySet("intervalInSeconds")) {
                this.intervalInSeconds(model.getIntervalInSeconds());
            }
            if (model.wasPropertyExplicitlySet("failureThreshold")) {
                this.failureThreshold(model.getFailureThreshold());
            }
            if (model.wasPropertyExplicitlySet("successThreshold")) {
                this.successThreshold(model.getSuccessThreshold());
            }
            if (model.wasPropertyExplicitlySet("timeoutInSeconds")) {
                this.timeoutInSeconds(model.getTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("failureAction")) {
                this.failureAction(model.getFailureAction());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            return this;
        }
    }
}

