/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ShapeMemoryOptions;
import com.oracle.bmc.containerinstances.model.ShapeNetworkingBandwidthOptions;
import com.oracle.bmc.containerinstances.model.ShapeOcpuOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerInstanceShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="processorDescription")
    private final String processorDescription;
    @JsonProperty(value="ocpuOptions")
    private final ShapeOcpuOptions ocpuOptions;
    @JsonProperty(value="memoryOptions")
    private final ShapeMemoryOptions memoryOptions;
    @JsonProperty(value="networkingBandwidthOptions")
    private final ShapeNetworkingBandwidthOptions networkingBandwidthOptions;

    @Deprecated
    @ConstructorProperties(value={"name", "processorDescription", "ocpuOptions", "memoryOptions", "networkingBandwidthOptions"})
    public ContainerInstanceShapeSummary(String name, String processorDescription, ShapeOcpuOptions ocpuOptions, ShapeMemoryOptions memoryOptions, ShapeNetworkingBandwidthOptions networkingBandwidthOptions) {
        this.name = name;
        this.processorDescription = processorDescription;
        this.ocpuOptions = ocpuOptions;
        this.memoryOptions = memoryOptions;
        this.networkingBandwidthOptions = networkingBandwidthOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public ShapeOcpuOptions getOcpuOptions() {
        return this.ocpuOptions;
    }

    public ShapeMemoryOptions getMemoryOptions() {
        return this.memoryOptions;
    }

    public ShapeNetworkingBandwidthOptions getNetworkingBandwidthOptions() {
        return this.networkingBandwidthOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerInstanceShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", processorDescription=").append(String.valueOf(this.processorDescription));
        sb.append(", ocpuOptions=").append(String.valueOf((Object)this.ocpuOptions));
        sb.append(", memoryOptions=").append(String.valueOf((Object)this.memoryOptions));
        sb.append(", networkingBandwidthOptions=").append(String.valueOf((Object)this.networkingBandwidthOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerInstanceShapeSummary)) {
            return false;
        }
        ContainerInstanceShapeSummary other = (ContainerInstanceShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.processorDescription, other.processorDescription) && Objects.equals((Object)this.ocpuOptions, (Object)other.ocpuOptions) && Objects.equals((Object)this.memoryOptions, (Object)other.memoryOptions) && Objects.equals((Object)this.networkingBandwidthOptions, (Object)other.networkingBandwidthOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.processorDescription == null ? 43 : this.processorDescription.hashCode());
        result = result * 59 + (this.ocpuOptions == null ? 43 : this.ocpuOptions.hashCode());
        result = result * 59 + (this.memoryOptions == null ? 43 : this.memoryOptions.hashCode());
        result = result * 59 + (this.networkingBandwidthOptions == null ? 43 : this.networkingBandwidthOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="processorDescription")
        private String processorDescription;
        @JsonProperty(value="ocpuOptions")
        private ShapeOcpuOptions ocpuOptions;
        @JsonProperty(value="memoryOptions")
        private ShapeMemoryOptions memoryOptions;
        @JsonProperty(value="networkingBandwidthOptions")
        private ShapeNetworkingBandwidthOptions networkingBandwidthOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder processorDescription(String processorDescription) {
            this.processorDescription = processorDescription;
            this.__explicitlySet__.add("processorDescription");
            return this;
        }

        public Builder ocpuOptions(ShapeOcpuOptions ocpuOptions) {
            this.ocpuOptions = ocpuOptions;
            this.__explicitlySet__.add("ocpuOptions");
            return this;
        }

        public Builder memoryOptions(ShapeMemoryOptions memoryOptions) {
            this.memoryOptions = memoryOptions;
            this.__explicitlySet__.add("memoryOptions");
            return this;
        }

        public Builder networkingBandwidthOptions(ShapeNetworkingBandwidthOptions networkingBandwidthOptions) {
            this.networkingBandwidthOptions = networkingBandwidthOptions;
            this.__explicitlySet__.add("networkingBandwidthOptions");
            return this;
        }

        public ContainerInstanceShapeSummary build() {
            ContainerInstanceShapeSummary model = new ContainerInstanceShapeSummary(this.name, this.processorDescription, this.ocpuOptions, this.memoryOptions, this.networkingBandwidthOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerInstanceShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("processorDescription")) {
                this.processorDescription(model.getProcessorDescription());
            }
            if (model.wasPropertyExplicitlySet("ocpuOptions")) {
                this.ocpuOptions(model.getOcpuOptions());
            }
            if (model.wasPropertyExplicitlySet("memoryOptions")) {
                this.memoryOptions(model.getMemoryOptions());
            }
            if (model.wasPropertyExplicitlySet("networkingBandwidthOptions")) {
                this.networkingBandwidthOptions(model.getNetworkingBandwidthOptions());
            }
            return this;
        }
    }
}

