/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ContainerDnsConfig;
import com.oracle.bmc.containerinstances.model.ContainerInstanceContainer;
import com.oracle.bmc.containerinstances.model.ContainerInstanceShapeConfig;
import com.oracle.bmc.containerinstances.model.ContainerVnic;
import com.oracle.bmc.containerinstances.model.ContainerVolume;
import com.oracle.bmc.containerinstances.model.ImagePullSecret;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="volumes")
    private final List<ContainerVolume> volumes;
    @JsonProperty(value="volumeCount")
    private final Integer volumeCount;
    @JsonProperty(value="containers")
    private final List<ContainerInstanceContainer> containers;
    @JsonProperty(value="containerCount")
    private final Integer containerCount;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="shapeConfig")
    private final ContainerInstanceShapeConfig shapeConfig;
    @JsonProperty(value="vnics")
    private final List<ContainerVnic> vnics;
    @JsonProperty(value="dnsConfig")
    private final ContainerDnsConfig dnsConfig;
    @JsonProperty(value="gracefulShutdownTimeoutInSeconds")
    private final Long gracefulShutdownTimeoutInSeconds;
    @JsonProperty(value="imagePullSecrets")
    private final List<ImagePullSecret> imagePullSecrets;
    @JsonProperty(value="containerRestartPolicy")
    private final ContainerRestartPolicy containerRestartPolicy;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "freeformTags", "definedTags", "systemTags", "availabilityDomain", "faultDomain", "lifecycleState", "lifecycleDetails", "volumes", "volumeCount", "containers", "containerCount", "timeCreated", "timeUpdated", "shape", "shapeConfig", "vnics", "dnsConfig", "gracefulShutdownTimeoutInSeconds", "imagePullSecrets", "containerRestartPolicy"})
    public ContainerInstance(String id, String displayName, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String availabilityDomain, String faultDomain, LifecycleState lifecycleState, String lifecycleDetails, List<ContainerVolume> volumes, Integer volumeCount, List<ContainerInstanceContainer> containers, Integer containerCount, Date timeCreated, Date timeUpdated, String shape, ContainerInstanceShapeConfig shapeConfig, List<ContainerVnic> vnics, ContainerDnsConfig dnsConfig, Long gracefulShutdownTimeoutInSeconds, List<ImagePullSecret> imagePullSecrets, ContainerRestartPolicy containerRestartPolicy) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.volumes = volumes;
        this.volumeCount = volumeCount;
        this.containers = containers;
        this.containerCount = containerCount;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.shape = shape;
        this.shapeConfig = shapeConfig;
        this.vnics = vnics;
        this.dnsConfig = dnsConfig;
        this.gracefulShutdownTimeoutInSeconds = gracefulShutdownTimeoutInSeconds;
        this.imagePullSecrets = imagePullSecrets;
        this.containerRestartPolicy = containerRestartPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<ContainerVolume> getVolumes() {
        return this.volumes;
    }

    public Integer getVolumeCount() {
        return this.volumeCount;
    }

    public List<ContainerInstanceContainer> getContainers() {
        return this.containers;
    }

    public Integer getContainerCount() {
        return this.containerCount;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getShape() {
        return this.shape;
    }

    public ContainerInstanceShapeConfig getShapeConfig() {
        return this.shapeConfig;
    }

    public List<ContainerVnic> getVnics() {
        return this.vnics;
    }

    public ContainerDnsConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public Long getGracefulShutdownTimeoutInSeconds() {
        return this.gracefulShutdownTimeoutInSeconds;
    }

    public List<ImagePullSecret> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public ContainerRestartPolicy getContainerRestartPolicy() {
        return this.containerRestartPolicy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", volumes=").append(String.valueOf(this.volumes));
        sb.append(", volumeCount=").append(String.valueOf(this.volumeCount));
        sb.append(", containers=").append(String.valueOf(this.containers));
        sb.append(", containerCount=").append(String.valueOf(this.containerCount));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", vnics=").append(String.valueOf(this.vnics));
        sb.append(", dnsConfig=").append(String.valueOf((Object)this.dnsConfig));
        sb.append(", gracefulShutdownTimeoutInSeconds=").append(String.valueOf(this.gracefulShutdownTimeoutInSeconds));
        sb.append(", imagePullSecrets=").append(String.valueOf(this.imagePullSecrets));
        sb.append(", containerRestartPolicy=").append(String.valueOf((Object)this.containerRestartPolicy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerInstance)) {
            return false;
        }
        ContainerInstance other = (ContainerInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.volumes, other.volumes) && Objects.equals(this.volumeCount, other.volumeCount) && Objects.equals(this.containers, other.containers) && Objects.equals(this.containerCount, other.containerCount) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals(this.vnics, other.vnics) && Objects.equals((Object)this.dnsConfig, (Object)other.dnsConfig) && Objects.equals(this.gracefulShutdownTimeoutInSeconds, other.gracefulShutdownTimeoutInSeconds) && Objects.equals(this.imagePullSecrets, other.imagePullSecrets) && Objects.equals((Object)this.containerRestartPolicy, (Object)other.containerRestartPolicy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.volumes == null ? 43 : this.volumes.hashCode());
        result = result * 59 + (this.volumeCount == null ? 43 : this.volumeCount.hashCode());
        result = result * 59 + (this.containers == null ? 43 : this.containers.hashCode());
        result = result * 59 + (this.containerCount == null ? 43 : this.containerCount.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.vnics == null ? 43 : this.vnics.hashCode());
        result = result * 59 + (this.dnsConfig == null ? 43 : this.dnsConfig.hashCode());
        result = result * 59 + (this.gracefulShutdownTimeoutInSeconds == null ? 43 : this.gracefulShutdownTimeoutInSeconds.hashCode());
        result = result * 59 + (this.imagePullSecrets == null ? 43 : this.imagePullSecrets.hashCode());
        result = result * 59 + (this.containerRestartPolicy == null ? 43 : this.containerRestartPolicy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ContainerRestartPolicy implements BmcEnum
    {
        Always("ALWAYS"),
        Never("NEVER"),
        OnFailure("ON_FAILURE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContainerRestartPolicy> map;

        private ContainerRestartPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContainerRestartPolicy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContainerRestartPolicy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContainerRestartPolicy.class);
            map = new HashMap<String, ContainerRestartPolicy>();
            for (ContainerRestartPolicy v : ContainerRestartPolicy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="volumes")
        private List<ContainerVolume> volumes;
        @JsonProperty(value="volumeCount")
        private Integer volumeCount;
        @JsonProperty(value="containers")
        private List<ContainerInstanceContainer> containers;
        @JsonProperty(value="containerCount")
        private Integer containerCount;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="shapeConfig")
        private ContainerInstanceShapeConfig shapeConfig;
        @JsonProperty(value="vnics")
        private List<ContainerVnic> vnics;
        @JsonProperty(value="dnsConfig")
        private ContainerDnsConfig dnsConfig;
        @JsonProperty(value="gracefulShutdownTimeoutInSeconds")
        private Long gracefulShutdownTimeoutInSeconds;
        @JsonProperty(value="imagePullSecrets")
        private List<ImagePullSecret> imagePullSecrets;
        @JsonProperty(value="containerRestartPolicy")
        private ContainerRestartPolicy containerRestartPolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder volumes(List<ContainerVolume> volumes) {
            this.volumes = volumes;
            this.__explicitlySet__.add("volumes");
            return this;
        }

        public Builder volumeCount(Integer volumeCount) {
            this.volumeCount = volumeCount;
            this.__explicitlySet__.add("volumeCount");
            return this;
        }

        public Builder containers(List<ContainerInstanceContainer> containers) {
            this.containers = containers;
            this.__explicitlySet__.add("containers");
            return this;
        }

        public Builder containerCount(Integer containerCount) {
            this.containerCount = containerCount;
            this.__explicitlySet__.add("containerCount");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeConfig(ContainerInstanceShapeConfig shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder vnics(List<ContainerVnic> vnics) {
            this.vnics = vnics;
            this.__explicitlySet__.add("vnics");
            return this;
        }

        public Builder dnsConfig(ContainerDnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            this.__explicitlySet__.add("dnsConfig");
            return this;
        }

        public Builder gracefulShutdownTimeoutInSeconds(Long gracefulShutdownTimeoutInSeconds) {
            this.gracefulShutdownTimeoutInSeconds = gracefulShutdownTimeoutInSeconds;
            this.__explicitlySet__.add("gracefulShutdownTimeoutInSeconds");
            return this;
        }

        public Builder imagePullSecrets(List<ImagePullSecret> imagePullSecrets) {
            this.imagePullSecrets = imagePullSecrets;
            this.__explicitlySet__.add("imagePullSecrets");
            return this;
        }

        public Builder containerRestartPolicy(ContainerRestartPolicy containerRestartPolicy) {
            this.containerRestartPolicy = containerRestartPolicy;
            this.__explicitlySet__.add("containerRestartPolicy");
            return this;
        }

        public ContainerInstance build() {
            ContainerInstance model = new ContainerInstance(this.id, this.displayName, this.compartmentId, this.freeformTags, this.definedTags, this.systemTags, this.availabilityDomain, this.faultDomain, this.lifecycleState, this.lifecycleDetails, this.volumes, this.volumeCount, this.containers, this.containerCount, this.timeCreated, this.timeUpdated, this.shape, this.shapeConfig, this.vnics, this.dnsConfig, this.gracefulShutdownTimeoutInSeconds, this.imagePullSecrets, this.containerRestartPolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("volumes")) {
                this.volumes(model.getVolumes());
            }
            if (model.wasPropertyExplicitlySet("volumeCount")) {
                this.volumeCount(model.getVolumeCount());
            }
            if (model.wasPropertyExplicitlySet("containers")) {
                this.containers(model.getContainers());
            }
            if (model.wasPropertyExplicitlySet("containerCount")) {
                this.containerCount(model.getContainerCount());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("vnics")) {
                this.vnics(model.getVnics());
            }
            if (model.wasPropertyExplicitlySet("dnsConfig")) {
                this.dnsConfig(model.getDnsConfig());
            }
            if (model.wasPropertyExplicitlySet("gracefulShutdownTimeoutInSeconds")) {
                this.gracefulShutdownTimeoutInSeconds(model.getGracefulShutdownTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("imagePullSecrets")) {
                this.imagePullSecrets(model.getImagePullSecrets());
            }
            if (model.wasPropertyExplicitlySet("containerRestartPolicy")) {
                this.containerRestartPolicy(model.getContainerRestartPolicy());
            }
            return this;
        }
    }
}

