/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.ClusterCreateOptions;
import com.oracle.bmc.containerengine.model.ClusterPodNetworkOptionDetails;
import com.oracle.bmc.containerengine.model.CreateClusterEndpointConfigDetails;
import com.oracle.bmc.containerengine.model.CreateImagePolicyConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="endpointConfig")
    private final CreateClusterEndpointConfigDetails endpointConfig;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="kubernetesVersion")
    private final String kubernetesVersion;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="options")
    private final ClusterCreateOptions options;
    @JsonProperty(value="imagePolicyConfig")
    private final CreateImagePolicyConfigDetails imagePolicyConfig;
    @JsonProperty(value="clusterPodNetworkOptions")
    private final List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;

    @Deprecated
    @ConstructorProperties(value={"name", "compartmentId", "endpointConfig", "vcnId", "kubernetesVersion", "kmsKeyId", "freeformTags", "definedTags", "options", "imagePolicyConfig", "clusterPodNetworkOptions"})
    public CreateClusterDetails(String name, String compartmentId, CreateClusterEndpointConfigDetails endpointConfig, String vcnId, String kubernetesVersion, String kmsKeyId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ClusterCreateOptions options, CreateImagePolicyConfigDetails imagePolicyConfig, List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions) {
        this.name = name;
        this.compartmentId = compartmentId;
        this.endpointConfig = endpointConfig;
        this.vcnId = vcnId;
        this.kubernetesVersion = kubernetesVersion;
        this.kmsKeyId = kmsKeyId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.options = options;
        this.imagePolicyConfig = imagePolicyConfig;
        this.clusterPodNetworkOptions = clusterPodNetworkOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CreateClusterEndpointConfigDetails getEndpointConfig() {
        return this.endpointConfig;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getKubernetesVersion() {
        return this.kubernetesVersion;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public ClusterCreateOptions getOptions() {
        return this.options;
    }

    public CreateImagePolicyConfigDetails getImagePolicyConfig() {
        return this.imagePolicyConfig;
    }

    public List<ClusterPodNetworkOptionDetails> getClusterPodNetworkOptions() {
        return this.clusterPodNetworkOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", endpointConfig=").append(String.valueOf((Object)this.endpointConfig));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", kubernetesVersion=").append(String.valueOf(this.kubernetesVersion));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", options=").append(String.valueOf((Object)this.options));
        sb.append(", imagePolicyConfig=").append(String.valueOf((Object)this.imagePolicyConfig));
        sb.append(", clusterPodNetworkOptions=").append(String.valueOf(this.clusterPodNetworkOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateClusterDetails)) {
            return false;
        }
        CreateClusterDetails other = (CreateClusterDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.endpointConfig, (Object)other.endpointConfig) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.kubernetesVersion, other.kubernetesVersion) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.options, (Object)other.options) && Objects.equals((Object)this.imagePolicyConfig, (Object)other.imagePolicyConfig) && Objects.equals(this.clusterPodNetworkOptions, other.clusterPodNetworkOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.endpointConfig == null ? 43 : this.endpointConfig.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.kubernetesVersion == null ? 43 : this.kubernetesVersion.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.options == null ? 43 : this.options.hashCode());
        result = result * 59 + (this.imagePolicyConfig == null ? 43 : this.imagePolicyConfig.hashCode());
        result = result * 59 + (this.clusterPodNetworkOptions == null ? 43 : this.clusterPodNetworkOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="endpointConfig")
        private CreateClusterEndpointConfigDetails endpointConfig;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="kubernetesVersion")
        private String kubernetesVersion;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="options")
        private ClusterCreateOptions options;
        @JsonProperty(value="imagePolicyConfig")
        private CreateImagePolicyConfigDetails imagePolicyConfig;
        @JsonProperty(value="clusterPodNetworkOptions")
        private List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder endpointConfig(CreateClusterEndpointConfigDetails endpointConfig) {
            this.endpointConfig = endpointConfig;
            this.__explicitlySet__.add("endpointConfig");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            this.__explicitlySet__.add("kubernetesVersion");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder options(ClusterCreateOptions options) {
            this.options = options;
            this.__explicitlySet__.add("options");
            return this;
        }

        public Builder imagePolicyConfig(CreateImagePolicyConfigDetails imagePolicyConfig) {
            this.imagePolicyConfig = imagePolicyConfig;
            this.__explicitlySet__.add("imagePolicyConfig");
            return this;
        }

        public Builder clusterPodNetworkOptions(List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions) {
            this.clusterPodNetworkOptions = clusterPodNetworkOptions;
            this.__explicitlySet__.add("clusterPodNetworkOptions");
            return this;
        }

        public CreateClusterDetails build() {
            CreateClusterDetails model = new CreateClusterDetails(this.name, this.compartmentId, this.endpointConfig, this.vcnId, this.kubernetesVersion, this.kmsKeyId, this.freeformTags, this.definedTags, this.options, this.imagePolicyConfig, this.clusterPodNetworkOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateClusterDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("endpointConfig")) {
                this.endpointConfig(model.getEndpointConfig());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("kubernetesVersion")) {
                this.kubernetesVersion(model.getKubernetesVersion());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("options")) {
                this.options(model.getOptions());
            }
            if (model.wasPropertyExplicitlySet("imagePolicyConfig")) {
                this.imagePolicyConfig(model.getImagePolicyConfig());
            }
            if (model.wasPropertyExplicitlySet("clusterPodNetworkOptions")) {
                this.clusterPodNetworkOptions(model.getClusterPodNetworkOptions());
            }
            return this;
        }
    }
}

