/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerengine.ContainerEngineAsync;
import com.oracle.bmc.containerengine.model.Cluster;
import com.oracle.bmc.containerengine.model.ClusterMigrateToNativeVcnStatus;
import com.oracle.bmc.containerengine.model.ClusterOptions;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.NodePool;
import com.oracle.bmc.containerengine.model.NodePoolOptions;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.WorkRequest;
import com.oracle.bmc.containerengine.model.WorkRequestError;
import com.oracle.bmc.containerengine.model.WorkRequestLogEntry;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.requests.ClusterMigrateToNativeVcnRequest;
import com.oracle.bmc.containerengine.requests.CreateClusterRequest;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.requests.CreateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteClusterRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodeRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.GetClusterMigrateToNativeVcnStatusRequest;
import com.oracle.bmc.containerengine.requests.GetClusterOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterEndpointConfigRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterRequest;
import com.oracle.bmc.containerengine.requests.UpdateNodePoolRequest;
import com.oracle.bmc.containerengine.responses.ClusterMigrateToNativeVcnResponse;
import com.oracle.bmc.containerengine.responses.CreateClusterResponse;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.containerengine.responses.CreateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteClusterResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodeResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.GetClusterMigrateToNativeVcnStatusResponse;
import com.oracle.bmc.containerengine.responses.GetClusterOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterEndpointConfigResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterResponse;
import com.oracle.bmc.containerengine.responses.UpdateNodePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEngineAsyncClient
extends BaseAsyncClient
implements ContainerEngineAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERENGINE").serviceEndpointPrefix("containerengine").serviceEndpointTemplate("https://containerengine.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEngineAsyncClient.class);

    private ContainerEngineAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ClusterMigrateToNativeVcnResponse> clusterMigrateToNativeVcn(ClusterMigrateToNativeVcnRequest request, AsyncHandler<ClusterMigrateToNativeVcnRequest, ClusterMigrateToNativeVcnResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getClusterMigrateToNativeVcnDetails(), "clusterMigrateToNativeVcnDetails is required");
        return this.clientCall(request, ClusterMigrateToNativeVcnResponse::builder).logger(LOG, "clusterMigrateToNativeVcn").serviceDetails("ContainerEngine", "ClusterMigrateToNativeVcn", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/ClusterMigrateToNativeVcn").method(Method.POST).requestBuilder(ClusterMigrateToNativeVcnRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("migrateToNativeVcn").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateClusterResponse> createCluster(CreateClusterRequest request, AsyncHandler<CreateClusterRequest, CreateClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateClusterDetails(), "createClusterDetails is required");
        return this.clientCall(request, CreateClusterResponse::builder).logger(LOG, "createCluster").serviceDetails("ContainerEngine", "CreateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateCluster").method(Method.POST).requestBuilder(CreateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateKubeconfigResponse> createKubeconfig(CreateKubeconfigRequest request, AsyncHandler<CreateKubeconfigRequest, CreateKubeconfigResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateKubeconfigResponse::builder).logger(LOG, "createKubeconfig").serviceDetails("ContainerEngine", "CreateKubeconfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateKubeconfig").method(Method.POST).requestBuilder(CreateKubeconfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("kubeconfig").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, CreateKubeconfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", CreateKubeconfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateNodePoolResponse> createNodePool(CreateNodePoolRequest request, AsyncHandler<CreateNodePoolRequest, CreateNodePoolResponse> handler) {
        Objects.requireNonNull(request.getCreateNodePoolDetails(), "createNodePoolDetails is required");
        return this.clientCall(request, CreateNodePoolResponse::builder).logger(LOG, "createNodePool").serviceDetails("ContainerEngine", "CreateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/CreateNodePool").method(Method.POST).requestBuilder(CreateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request, AsyncHandler<DeleteClusterRequest, DeleteClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteClusterResponse::builder).logger(LOG, "deleteCluster").serviceDetails("ContainerEngine", "DeleteCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/DeleteCluster").method(Method.DELETE).requestBuilder(DeleteClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNodeResponse> deleteNode(DeleteNodeRequest request, AsyncHandler<DeleteNodeRequest, DeleteNodeResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNodeId(), (String)"nodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNodeResponse::builder).logger(LOG, "deleteNode").serviceDetails("ContainerEngine", "DeleteNode", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNode").method(Method.DELETE).requestBuilder(DeleteNodeRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendPathParam("node").appendPathParam(request.getNodeId()).appendQueryParam("isDecrementSize", (Object)request.getIsDecrementSize()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNodePoolResponse> deleteNodePool(DeleteNodePoolRequest request, AsyncHandler<DeleteNodePoolRequest, DeleteNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNodePoolResponse::builder).logger(LOG, "deleteNodePool").serviceDetails("ContainerEngine", "DeleteNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNodePool").method(Method.DELETE).requestBuilder(DeleteNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("ContainerEngine", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterResponse> getCluster(GetClusterRequest request, AsyncHandler<GetClusterRequest, GetClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterResponse::builder).logger(LOG, "getCluster").serviceDetails("ContainerEngine", "GetCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/GetCluster").method(Method.GET).requestBuilder(GetClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Cluster.class, GetClusterResponse.Builder::cluster).handleResponseHeaderString("etag", GetClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterMigrateToNativeVcnStatusResponse> getClusterMigrateToNativeVcnStatus(GetClusterMigrateToNativeVcnStatusRequest request, AsyncHandler<GetClusterMigrateToNativeVcnStatusRequest, GetClusterMigrateToNativeVcnStatusResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterMigrateToNativeVcnStatusResponse::builder).logger(LOG, "getClusterMigrateToNativeVcnStatus").serviceDetails("ContainerEngine", "GetClusterMigrateToNativeVcnStatus", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterMigrateToNativeVcnStatus/GetClusterMigrateToNativeVcnStatus").method(Method.GET).requestBuilder(GetClusterMigrateToNativeVcnStatusRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("migrateToNativeVcnStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterMigrateToNativeVcnStatus.class, GetClusterMigrateToNativeVcnStatusResponse.Builder::clusterMigrateToNativeVcnStatus).handleResponseHeaderString("etag", GetClusterMigrateToNativeVcnStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterMigrateToNativeVcnStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterOptionsResponse> getClusterOptions(GetClusterOptionsRequest request, AsyncHandler<GetClusterOptionsRequest, GetClusterOptionsResponse> handler) {
        Validate.notBlank((String)request.getClusterOptionId(), (String)"clusterOptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterOptionsResponse::builder).logger(LOG, "getClusterOptions").serviceDetails("ContainerEngine", "GetClusterOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterOptions/GetClusterOptions").method(Method.GET).requestBuilder(GetClusterOptionsRequest::builder).basePath("/20180222").appendPathParam("clusterOptions").appendPathParam(request.getClusterOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterOptions.class, GetClusterOptionsResponse.Builder::clusterOptions).handleResponseHeaderString("opc-request-id", GetClusterOptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNodePoolResponse> getNodePool(GetNodePoolRequest request, AsyncHandler<GetNodePoolRequest, GetNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNodePoolResponse::builder).logger(LOG, "getNodePool").serviceDetails("ContainerEngine", "GetNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/GetNodePool").method(Method.GET).requestBuilder(GetNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePool.class, GetNodePoolResponse.Builder::nodePool).handleResponseHeaderString("etag", GetNodePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNodePoolOptionsResponse> getNodePoolOptions(GetNodePoolOptionsRequest request, AsyncHandler<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> handler) {
        Validate.notBlank((String)request.getNodePoolOptionId(), (String)"nodePoolOptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNodePoolOptionsResponse::builder).logger(LOG, "getNodePoolOptions").serviceDetails("ContainerEngine", "GetNodePoolOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolOptions/GetNodePoolOptions").method(Method.GET).requestBuilder(GetNodePoolOptionsRequest::builder).basePath("/20180222").appendPathParam("nodePoolOptions").appendPathParam(request.getNodePoolOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePoolOptions.class, GetNodePoolOptionsResponse.Builder::nodePoolOptions).handleResponseHeaderString("opc-request-id", GetNodePoolOptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ContainerEngine", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListClustersResponse> listClusters(ListClustersRequest request, AsyncHandler<ListClustersRequest, ListClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListClustersResponse::builder).logger(LOG, "listClusters").serviceDetails("ContainerEngine", "ListClusters", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterSummary/ListClusters").method(Method.GET).requestBuilder(ListClustersRequest::builder).basePath("/20180222").appendPathParam("clusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ClusterSummary.class, ListClustersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListClustersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListNodePoolsResponse> listNodePools(ListNodePoolsRequest request, AsyncHandler<ListNodePoolsRequest, ListNodePoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNodePoolsResponse::builder).logger(LOG, "listNodePools").serviceDetails("ContainerEngine", "ListNodePools", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolSummary/ListNodePools").method(Method.GET).requestBuilder(ListNodePoolsRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NodePoolSummary.class, ListNodePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNodePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNodePoolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ContainerEngine", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ContainerEngine", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ContainerEngine", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("resourceType", (BmcEnum)request.getResourceType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterResponse> updateCluster(UpdateClusterRequest request, AsyncHandler<UpdateClusterRequest, UpdateClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterDetails(), "updateClusterDetails is required");
        return this.clientCall(request, UpdateClusterResponse::builder).logger(LOG, "updateCluster").serviceDetails("ContainerEngine", "UpdateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateCluster").method(Method.PUT).requestBuilder(UpdateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterEndpointConfigResponse> updateClusterEndpointConfig(UpdateClusterEndpointConfigRequest request, AsyncHandler<UpdateClusterEndpointConfigRequest, UpdateClusterEndpointConfigResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterEndpointConfigDetails(), "updateClusterEndpointConfigDetails is required");
        return this.clientCall(request, UpdateClusterEndpointConfigResponse::builder).logger(LOG, "updateClusterEndpointConfig").serviceDetails("ContainerEngine", "UpdateClusterEndpointConfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateClusterEndpointConfig").method(Method.POST).requestBuilder(UpdateClusterEndpointConfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("updateEndpointConfig").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterEndpointConfigResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterEndpointConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateNodePoolResponse> updateNodePool(UpdateNodePoolRequest request, AsyncHandler<UpdateNodePoolRequest, UpdateNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNodePoolDetails(), "updateNodePoolDetails is required");
        return this.clientCall(request, UpdateNodePoolResponse::builder).logger(LOG, "updateNodePool").serviceDetails("ContainerEngine", "UpdateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/UpdateNodePool").method(Method.PUT).requestBuilder(UpdateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ContainerEngineAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ContainerEngineAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerEngineAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ContainerEngineAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ContainerEngineAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

