/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstanceAgentPluginRequest
extends BmcRequest<Void> {
    private String instanceagentId;
    private String compartmentId;
    private String pluginName;
    private String opcRequestId;

    public String getInstanceagentId() {
        return this.instanceagentId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().instanceagentId(this.instanceagentId).compartmentId(this.compartmentId).pluginName(this.pluginName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceagentId=").append(String.valueOf(this.instanceagentId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",pluginName=").append(String.valueOf(this.pluginName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstanceAgentPluginRequest)) {
            return false;
        }
        GetInstanceAgentPluginRequest other = (GetInstanceAgentPluginRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceagentId, other.instanceagentId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.pluginName, other.pluginName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceagentId == null ? 43 : this.instanceagentId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.pluginName == null ? 43 : this.pluginName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceAgentPluginRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceagentId = null;
        private String compartmentId = null;
        private String pluginName = null;
        private String opcRequestId = null;

        public Builder instanceagentId(String instanceagentId) {
            this.instanceagentId = instanceagentId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceAgentPluginRequest o) {
            this.instanceagentId(o.getInstanceagentId());
            this.compartmentId(o.getCompartmentId());
            this.pluginName(o.getPluginName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceAgentPluginRequest build() {
            GetInstanceAgentPluginRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstanceAgentPluginRequest buildWithoutInvocationCallback() {
            GetInstanceAgentPluginRequest request = new GetInstanceAgentPluginRequest();
            request.instanceagentId = this.instanceagentId;
            request.compartmentId = this.compartmentId;
            request.pluginName = this.pluginName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

