/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.Service;
import com.oracle.bmc.util.internal.Validate;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Map<String, Service> SERVICE_CACHE = new HashMap<String, Service>();
    private static final Logger LOG = LoggerFactory.getLogger(Services.class);

    @Deprecated
    public static Service create(String serviceName, String serviceEndpointPrefix) {
        return Services.serviceBuilder().serviceName(serviceName).serviceEndpointPrefix(serviceEndpointPrefix).build();
    }

    public static Service getServiceByName(String serviceName) {
        return SERVICE_CACHE.get(serviceName);
    }

    private static synchronized Service create(String serviceName, String serviceEndpointPrefix, String serviceEndpointTemplate, String endpointServiceName, Map<String, String> serviceEndpointTemplatesForRealms) {
        return Services.create(serviceName, serviceEndpointPrefix, serviceEndpointTemplate, endpointServiceName, serviceEndpointTemplatesForRealms, false);
    }

    private static synchronized Service create(String serviceName, String serviceEndpointPrefix, String serviceEndpointTemplate, String endpointServiceName, Map<String, String> serviceEndpointTemplatesForRealms, boolean serviceUsesDualStackByDefault) {
        Validate.notBlank(serviceName, "serviceName must be set to a non-empty string", new Object[0]);
        BasicService newInstance = new BasicService(serviceName, serviceEndpointPrefix, serviceEndpointTemplate, endpointServiceName, serviceEndpointTemplatesForRealms, serviceUsesDualStackByDefault);
        if (SERVICE_CACHE.containsKey(serviceName)) {
            Service existing = SERVICE_CACHE.get(serviceName);
            if (existing.equals(newInstance)) {
                return existing;
            }
            throw new IllegalArgumentException(String.format("Cannot redefine service '%s'. Existing: '%s', New: '%s'", serviceName, existing, newInstance));
        }
        LOG.info("Registering new service: {}", (Object)newInstance);
        SERVICE_CACHE.put(serviceName, newInstance);
        return newInstance;
    }

    public static ServiceBuilder serviceBuilder() {
        return new ServiceBuilder();
    }

    public static class ServiceBuilder {
        private String serviceName;
        private String serviceEndpointPrefix;
        private String serviceEndpointTemplate;
        private String endpointServiceName;
        private Map<String, String> serviceEndpointTemplatesForRealms = new HashMap<String, String>();
        private boolean serviceUsesDualStackByDefault;

        ServiceBuilder() {
        }

        public ServiceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceBuilder serviceEndpointPrefix(String serviceEndpointPrefix) {
            this.serviceEndpointPrefix = serviceEndpointPrefix;
            return this;
        }

        public ServiceBuilder serviceEndpointTemplate(String serviceEndpointTemplate) {
            this.serviceEndpointTemplate = serviceEndpointTemplate;
            return this;
        }

        public ServiceBuilder addServiceEndpointTemplateForRealm(String realmId, String endpoint) {
            this.serviceEndpointTemplatesForRealms.put(realmId, endpoint);
            return this;
        }

        public ServiceBuilder endpointServiceName(String endpointServiceName) {
            this.endpointServiceName = endpointServiceName;
            return this;
        }

        public ServiceBuilder serviceUsesDualStackByDefault() {
            this.serviceUsesDualStackByDefault = true;
            return this;
        }

        public Service build() {
            return Services.create(this.serviceName, this.serviceEndpointPrefix, this.serviceEndpointTemplate, this.endpointServiceName, this.serviceEndpointTemplatesForRealms, this.serviceUsesDualStackByDefault);
        }

        public String toString() {
            return "Services.ServiceBuilder(serviceName=" + this.serviceName + ", serviceEndpointPrefix=" + this.serviceEndpointPrefix + ", serviceEndpointTemplate=" + this.serviceEndpointTemplate + ", endpointServiceName=" + this.endpointServiceName + ", serviceEndpointTemplatesForRealms=" + this.serviceEndpointTemplatesForRealms + ", serviceUsesDualStackByDefault=" + this.serviceUsesDualStackByDefault + ")";
        }
    }

    private static final class BasicService
    implements Service {
        private final String serviceName;
        private final String serviceEndpointPrefix;
        private final String serviceEndpointTemplate;
        private final String endpointServiceName;
        private final Map<String, String> serviceEndpointTemplatesForRealms = new HashMap<String, String>();
        private final boolean serviceUsesDualStackByDefault;

        @ConstructorProperties(value={"serviceName", "serviceEndpointPrefix", "serviceEndpointTemplate", "endpointServiceName", "serviceEndpointTemplatesForRealms", "serviceUsesDualStackByDefault"})
        public BasicService(String serviceName, String serviceEndpointPrefix, String serviceEndpointTemplate, String endpointServiceName, Map<String, String> serviceEndpointTemplatesForRealms, boolean serviceUsesDualStackByDefault) {
            this.serviceName = serviceName;
            this.serviceEndpointPrefix = serviceEndpointPrefix;
            this.serviceEndpointTemplate = serviceEndpointTemplate;
            this.endpointServiceName = endpointServiceName;
            this.serviceEndpointTemplatesForRealms.putAll(serviceEndpointTemplatesForRealms);
            this.serviceUsesDualStackByDefault = serviceUsesDualStackByDefault;
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        public String getServiceEndpointPrefix() {
            return this.serviceEndpointPrefix;
        }

        @Override
        public String getServiceEndpointTemplate() {
            return this.serviceEndpointTemplate;
        }

        @Override
        public void addServiceEndpointTemplateForRealm(String realmId, String endpoint) {
            this.serviceEndpointTemplatesForRealms.put(realmId, endpoint);
        }

        @Override
        public Map<String, String> getServiceEndpointTemplateForRealmMap() {
            return Collections.unmodifiableMap(this.serviceEndpointTemplatesForRealms);
        }

        @Override
        public String getEndpointServiceName() {
            return this.endpointServiceName;
        }

        @Override
        public boolean serviceUsesDualStackByDefault() {
            return this.serviceUsesDualStackByDefault;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicService)) {
                return false;
            }
            BasicService other = (BasicService)o;
            String this$serviceName = this.getServiceName();
            String other$serviceName = other.getServiceName();
            if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
                return false;
            }
            String this$serviceEndpointPrefix = this.getServiceEndpointPrefix();
            String other$serviceEndpointPrefix = other.getServiceEndpointPrefix();
            if (this$serviceEndpointPrefix == null ? other$serviceEndpointPrefix != null : !this$serviceEndpointPrefix.equals(other$serviceEndpointPrefix)) {
                return false;
            }
            String this$serviceEndpointTemplate = this.getServiceEndpointTemplate();
            String other$serviceEndpointTemplate = other.getServiceEndpointTemplate();
            if (this$serviceEndpointTemplate == null ? other$serviceEndpointTemplate != null : !this$serviceEndpointTemplate.equals(other$serviceEndpointTemplate)) {
                return false;
            }
            String this$endpointServiceName = this.getEndpointServiceName();
            String other$endpointServiceName = other.getEndpointServiceName();
            if (this$endpointServiceName == null ? other$endpointServiceName != null : !this$endpointServiceName.equals(other$endpointServiceName)) {
                return false;
            }
            Boolean this$serviceUsesDualStackByDefault = this.serviceUsesDualStackByDefault();
            Boolean other$serviceUsesDualStackByDefault = other.serviceUsesDualStackByDefault();
            return !(this$serviceUsesDualStackByDefault == null ? other$serviceUsesDualStackByDefault != null : !((Object)this$serviceUsesDualStackByDefault).equals(other$serviceUsesDualStackByDefault));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceName = this.getServiceName();
            result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
            String $serviceEndpointPrefix = this.getServiceEndpointPrefix();
            result = result * 59 + ($serviceEndpointPrefix == null ? 43 : $serviceEndpointPrefix.hashCode());
            String $serviceEndpointTemplate = this.getServiceEndpointTemplate();
            result = result * 59 + ($serviceEndpointTemplate == null ? 43 : $serviceEndpointTemplate.hashCode());
            String $endpointServiceName = this.getEndpointServiceName();
            result = result * 59 + ($endpointServiceName == null ? 43 : $endpointServiceName.hashCode());
            Map<String, String> $serviceEndpointTemplatesForRealms = this.getServiceEndpointTemplateForRealmMap();
            result = result * 59 + ($serviceEndpointTemplatesForRealms == null ? 43 : ((Object)$serviceEndpointTemplatesForRealms).hashCode());
            Boolean $serviceUsesDualStackByDefault = this.serviceUsesDualStackByDefault();
            result = result * 59 + ($serviceUsesDualStackByDefault == null ? 43 : ((Object)$serviceUsesDualStackByDefault).hashCode());
            return result;
        }

        public String toString() {
            return "Services.BasicService(serviceName=" + this.getServiceName() + ", serviceEndpointPrefix=" + this.getServiceEndpointPrefix() + ", serviceEndpointTemplate=" + this.getServiceEndpointTemplate() + ", endpointServiceName=" + this.getEndpointServiceName() + ", serviceEndpointTemplatesForRealms=" + this.getServiceEndpointTemplateForRealmMap() + ", serviceUsesDualStackByDefault=" + this.serviceUsesDualStackByDefault() + ")";
        }
    }
}

