/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Service;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.internal.SyncFutureWaiter;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.EndpointBuilder;
import com.oracle.bmc.model.RegionAlloySchema;
import com.oracle.bmc.model.RegionSchema;
import com.oracle.bmc.model.internal.JsonConverter;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.NameUtils;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategyWithJitter;
import com.oracle.bmc.waiter.WaiterConfiguration;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Region
implements Serializable,
Comparable<Region> {
    private static final String OCI_REGION_METADATA_ENV_VAR_NAME = "OCI_REGION_METADATA";
    private static final String OCI_DEFAULT_REALM_ENV_VAR_NAME = "OCI_DEFAULT_REALM";
    private static final String REGIONS_CONFIG_FILE_PATH = "~/.oci/regions-config.json";
    private static volatile String OCI_ALLOY_CONFIG_PROVIDER;
    private static volatile boolean IS_ALLOY_REGION_COEXIST_ENABLED;
    private static final Map<String, Region> KNOWN_REGIONS;
    private static final Map<String, Region> ALLOY_REGIONS;
    private static final Map<String, Region> ALL_REGIONS;
    private static final Logger LOG;
    private static volatile boolean hasUsedEnvVar;
    private static volatile boolean hasUsedConfigFile;
    private static volatile boolean hasUsedAlloyConfigFile;
    private static final ReentrantReadWriteLock lock;
    private static final Lock readLock;
    private static final Lock writeLock;
    @VisibleForTesting
    static volatile boolean hasUsedInstanceMetadataService;
    private static volatile boolean hasOptedForInstanceMetadataService;
    private static volatile boolean hasReceivedInstanceMetadataServiceResponse;
    private static volatile boolean hasWarnedAboutValuesWithoutInstanceMetadataService;
    @VisibleForTesting
    static volatile String defaultRealmEnvVar;
    public static volatile Region regionFromImds;
    public static final Region AP_CHUNCHEON_1;
    public static final Region AP_MELBOURNE_1;
    public static final Region AP_HYDERABAD_1;
    public static final Region AP_MUMBAI_1;
    public static final Region AP_OSAKA_1;
    public static final Region AP_SEOUL_1;
    public static final Region AP_SYDNEY_1;
    public static final Region AP_TOKYO_1;
    public static final Region CA_MONTREAL_1;
    public static final Region CA_TORONTO_1;
    public static final Region EU_AMSTERDAM_1;
    public static final Region EU_FRANKFURT_1;
    public static final Region EU_ZURICH_1;
    public static final Region ME_JEDDAH_1;
    public static final Region ME_DUBAI_1;
    public static final Region SA_SAOPAULO_1;
    public static final Region UK_LONDON_1;
    public static final Region US_ASHBURN_1;
    public static final Region US_PHOENIX_1;
    public static final Region US_SANJOSE_1;
    public static final Region UK_CARDIFF_1;
    public static final Region SA_SANTIAGO_1;
    public static final Region SA_VINHEDO_1;
    public static final Region IL_JERUSALEM_1;
    public static final Region EU_MARSEILLE_1;
    public static final Region AP_SINGAPORE_1;
    public static final Region ME_ABUDHABI_1;
    public static final Region EU_MILAN_1;
    public static final Region EU_STOCKHOLM_1;
    public static final Region AF_JOHANNESBURG_1;
    public static final Region EU_PARIS_1;
    public static final Region MX_QUERETARO_1;
    public static final Region EU_MADRID_1;
    public static final Region US_CHICAGO_1;
    public static final Region MX_MONTERREY_1;
    public static final Region US_SALTLAKE_2;
    public static final Region SA_BOGOTA_1;
    public static final Region SA_VALPARAISO_1;
    public static final Region AP_SINGAPORE_2;
    public static final Region US_LANGLEY_1;
    public static final Region US_LUKE_1;
    public static final Region US_GOV_ASHBURN_1;
    public static final Region US_GOV_CHICAGO_1;
    public static final Region US_GOV_PHOENIX_1;
    public static final Region UK_GOV_LONDON_1;
    public static final Region UK_GOV_CARDIFF_1;
    public static final Region AP_CHIYODA_1;
    public static final Region AP_IBARAKI_1;
    public static final Region ME_DCC_MUSCAT_1;
    public static final Region AP_DCC_CANBERRA_1;
    public static final Region EU_DCC_MILAN_1;
    public static final Region EU_DCC_MILAN_2;
    public static final Region EU_DCC_DUBLIN_2;
    public static final Region EU_DCC_RATING_2;
    public static final Region EU_DCC_RATING_1;
    public static final Region EU_DCC_DUBLIN_1;
    public static final Region EU_JOVANOVAC_1;
    public static final Region EU_MADRID_2;
    public static final Region EU_FRANKFURT_2;
    public static final Region EU_DCC_ZURICH_1;
    public static final Region ME_DCC_DOHA_1;
    public static final Region ME_ABUDHABI_3;
    public static final Region AP_DCC_GAZIPUR_1;
    public static final Region ME_ABUDHABI_2;
    private static final Map<String, Map<Region, String>> SERVICE_TO_REGION_ENDPOINTS;
    private static final Set<String> OCI_SDK_ENABLED_SERVICES_SET;
    private static final long serialVersionUID = -905384972L;
    private final String regionId;
    private final String regionCode;
    private final Realm realm;

    private static String getDefaultRealmFromEnv() {
        String defaultRealmEnvVar = System.getenv(OCI_DEFAULT_REALM_ENV_VAR_NAME);
        return defaultRealmEnvVar;
    }

    private Region(@Nonnull String regionId, @Nonnull Optional<String> regionCode, @Nonnull Realm realm) {
        this(regionId, regionCode, realm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region(@Nonnull String regionId, @Nonnull Optional<String> regionCode, @Nonnull Realm realm, boolean isAlloyRegion) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (regionCode == null) {
            throw new NullPointerException("regionCode is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        this.regionId = regionId;
        this.regionCode = regionCode.orElse(null);
        this.realm = realm;
        writeLock.lock();
        try {
            if (isAlloyRegion) {
                ALLOY_REGIONS.put(NameUtils.canonicalizeForEnumTypes(regionId), this);
            } else {
                KNOWN_REGIONS.put(NameUtils.canonicalizeForEnumTypes(regionId), this);
            }
            ALL_REGIONS.put(NameUtils.canonicalizeForEnumTypes(regionId), this);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Region getRegionFromImds() {
        return regionFromImds;
    }

    public String getRegionCode() {
        return this.regionCode != null ? this.regionCode : this.regionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getEndpoint(Service service) {
        writeLock.lock();
        try {
            Map<Object, Object> endpoints;
            if (!SERVICE_TO_REGION_ENDPOINTS.containsKey(service.getServiceName())) {
                endpoints = new HashMap<Region, String>();
                ((HashMap)endpoints).put(this, Region.formatDefaultRegionEndpoint(service, this));
                SERVICE_TO_REGION_ENDPOINTS.put(service.getServiceName(), endpoints);
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            if (!(endpoints = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName())).containsKey(this)) {
                endpoints.put(this, Region.formatDefaultRegionEndpoint(service, this));
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            String endpoint = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName()).get(this);
            Optional<String> optional = Optional.ofNullable(endpoint);
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int compareTo(Region other) {
        return this.regionId.compareTo(other.regionId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRegionId());
    }

    public static Region[] values() {
        if (!hasUsedInstanceMetadataService && !hasWarnedAboutValuesWithoutInstanceMetadataService) {
            LOG.warn("Call to Regions.values() without having contacted IMDS (Instance Metadata Service, only available on OCI instances); if you do need the region from IMDS, call Region.registerFromInstanceMetadataService before calling Region.values()");
            hasWarnedAboutValuesWithoutInstanceMetadataService = true;
        }
        Region.registerAllRegions();
        readLock.lock();
        try {
            if (Alloy.doesAlloyConfigExist()) {
                if (Alloy.shouldUseOnlyAlloyRegions()) {
                    Region[] regionArray = ALLOY_REGIONS.values().toArray(new Region[ALLOY_REGIONS.size()]);
                    return regionArray;
                }
                Region[] regionArray = ALL_REGIONS.values().toArray(new Region[ALL_REGIONS.size()]);
                return regionArray;
            }
            Region[] regionArray = KNOWN_REGIONS.values().toArray(new Region[KNOWN_REGIONS.size()]);
            return regionArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Region valueOf(@Nonnull String name) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(name);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown region " + name);
        }
        return maybeRegion.get();
    }

    public static String formatDefaultRegionEndpoint(Service service, Region region) {
        return EndpointBuilder.createEndpoint(service, region);
    }

    public static String formatDefaultRegionEndpoint(Service service, String regionId) {
        Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return Region.formatDefaultRegionEndpoint(service, maybeRegion.get());
        }
        LOG.debug("Unknown regionId '{}', will assume it's in Realm OC1", (Object)regionId);
        return EndpointBuilder.createEndpoint(service, regionId, Realm.OC1);
    }

    public static Region fromRegionId(String regionId) {
        Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return maybeRegion.get();
        }
        throw new IllegalArgumentException("Unknown regionId: " + regionId);
    }

    private static Optional<Region> maybeFromRegionId(String regionId) {
        return Region.getRegionAndRegisterIfNecessary(regionId);
    }

    public static Region fromRegionCode(String regionCode) {
        Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(regionCode);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown regionCode: " + regionCode);
        }
        return maybeRegion.get();
    }

    public static Region fromRegionCodeOrId(String regionCodeOrId) {
        Optional<Region> maybeRegion = Region.getRegionAndRegisterIfNecessary(regionCodeOrId);
        if (!maybeRegion.isPresent()) {
            throw new IllegalArgumentException("Unknown regionCodeOrId: " + regionCodeOrId);
        }
        return maybeRegion.get();
    }

    public static Region register(@Nonnull String regionId, @Nonnull Realm realm) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        return Region.register(regionId, realm, null);
    }

    public static Region register(@Nonnull String regionId, @Nonnull Realm realm, String regionCode) {
        return Region.register(regionId, realm, regionCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region register(@Nonnull String regionId, @Nonnull Realm realm, String regionCode, boolean isAlloyRegion) {
        Region region;
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        if ((regionId = regionId.trim().toLowerCase(Locale.US)).isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty regionId");
        }
        readLock.lock();
        try {
            region = Region.getRegion(regionId, realm, isAlloyRegion);
            if (region != null) {
                Region region2 = region;
                return region2;
            }
        }
        finally {
            readLock.unlock();
        }
        writeLock.lock();
        try {
            region = Region.getRegion(regionId, realm, isAlloyRegion);
            if (region != null) {
                Region region3 = region;
                return region3;
            }
            if (regionCode != null && (regionCode = regionCode.trim().toLowerCase(Locale.US)).isEmpty()) {
                regionCode = null;
            }
            Region region4 = new Region(regionId, Optional.ofNullable(regionCode), realm, isAlloyRegion);
            return region4;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Region getRegion(String regionId, Realm realm, boolean isAlloyRegion) {
        readLock.lock();
        try {
            Region region = isAlloyRegion ? Region.getRegionFromMap(ALLOY_REGIONS, regionId, realm) : Region.getRegionFromMap(KNOWN_REGIONS, regionId, realm);
            Region region2 = region;
            return region2;
        }
        finally {
            readLock.unlock();
        }
    }

    private static Region getRegionFromMap(Map<String, Region> regionMap, String regionId, Realm realm) {
        for (Region region : regionMap.values()) {
            if (!region.getRegionId().equals(regionId)) continue;
            if (!region.getRealm().equals(realm)) {
                throw new IllegalArgumentException("Region : " + regionId + " is already registered with " + region.getRealm() + ". It cannot be re-registered with a different realm.");
            }
            return region;
        }
        return null;
    }

    private static Optional<Region> maybeFromRegionCodeOrIdWithoutRegistering(String regionCodeOrId) {
        readLock.lock();
        try {
            Optional<Region> optional = KNOWN_REGIONS.values().stream().filter(r -> r.getRegionCode().equalsIgnoreCase(regionCodeOrId) || r.regionId.equalsIgnoreCase(regionCodeOrId)).findAny();
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    private static Optional<Region> maybeFromAlloyRegionCodeOrIdWithoutRegistering(String regionCodeOrId) {
        readLock.lock();
        try {
            Optional<Region> optional = ALLOY_REGIONS.values().stream().filter(r -> r.getRegionCode().equalsIgnoreCase(regionCodeOrId) || r.regionId.equalsIgnoreCase(regionCodeOrId)).findAny();
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    private static void registerAllRegions() {
        if (Alloy.doesAlloyConfigExist()) {
            if (!hasUsedAlloyConfigFile) {
                Region.readAlloyRegionConfigFile();
            }
            if (!Alloy.isAlloyRegionCoexistEnabled()) {
                return;
            }
        }
        if (!hasUsedConfigFile) {
            Region.readRegionConfigFile();
        }
        if (!hasUsedEnvVar) {
            Region.readEnvVar();
        }
    }

    private static Optional<Region> getRegionAndRegisterIfNecessary(String regionCodeOrId) {
        Optional<Region> maybeRegion;
        if (regionCodeOrId.contains("_")) {
            regionCodeOrId = NameUtils.decanonicalizeFromEnumTypes(regionCodeOrId);
        }
        if (Alloy.doesAlloyConfigExist()) {
            if (!hasUsedAlloyConfigFile) {
                Region.readAlloyRegionConfigFile();
            }
            if ((maybeRegion = Region.maybeFromAlloyRegionCodeOrIdWithoutRegistering(regionCodeOrId)).isPresent()) {
                return maybeRegion;
            }
            if (!Alloy.isAlloyRegionCoexistEnabled()) {
                LOG.error("The region '{}' you're targeting is not declared in the '{}' Alloy configuration file. Please check if this is the correct region you're targeting or contact the '{}' cloud provider for help. If you want to target both OCI regions and '{}' regions, please set the OCI_PLC_REGION_COEXIST env var to true.", new Object[]{regionCodeOrId, Alloy.getAlloyConfigFilePath(), OCI_ALLOY_CONFIG_PROVIDER, OCI_ALLOY_CONFIG_PROVIDER});
                throw new IllegalArgumentException("Unknown regionId " + regionCodeOrId + ", region information not defined in Alloy configuration.");
            }
        }
        if ((maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId)).isPresent()) {
            return maybeRegion;
        }
        if (!hasUsedConfigFile) {
            Region.readRegionConfigFile();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return maybeRegion;
            }
        }
        if (!hasUsedEnvVar) {
            Region.readEnvVar();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return maybeRegion;
            }
        }
        if (hasOptedForInstanceMetadataService && !hasUsedInstanceMetadataService) {
            Region.registerFromInstanceMetadataService();
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return maybeRegion;
            }
        }
        if (defaultRealmEnvVar != null && !StringUtils.isBlank(defaultRealmEnvVar)) {
            Region.registerRegionWithDefaultRealm(regionCodeOrId);
            maybeRegion = Region.maybeFromRegionCodeOrIdWithoutRegistering(regionCodeOrId);
            if (maybeRegion.isPresent()) {
                return maybeRegion;
            }
        }
        return Optional.empty();
    }

    private static void readEnvVar() {
        String envVar = System.getenv(OCI_REGION_METADATA_ENV_VAR_NAME);
        RegionSchema regionSchema = null;
        LOG.info("Region metadata schema from OCI_REGION_METADATA env variable is {}", (Object)envVar);
        hasUsedEnvVar = true;
        if (envVar != null) {
            regionSchema = JsonConverter.jsonBlobToObject(envVar, RegionSchema.class);
        }
        if (regionSchema != null && RegionSchema.isValid(regionSchema)) {
            Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
        }
    }

    private static void registerRegionWithDefaultRealm(String regionId) {
        LOG.info("Realm domain component from OCI_DEFAULT_REALM env variable is {}", (Object)defaultRealmEnvVar);
        String trimmedDefaultRealm = defaultRealmEnvVar.replaceAll("'", "").replaceAll("\"", "");
        Realm defaultRealmFromEnvVar = Realm.register("defaultRealmFromEnv", trimmedDefaultRealm);
        LOG.info("Unknown regionId '{}', default realm is defined, falling back to '{}'", (Object)regionId, (Object)trimmedDefaultRealm);
        if (defaultRealmFromEnvVar != null) {
            Region.register(regionId, defaultRealmFromEnvVar);
        }
    }

    private static void readRegionConfigFile() {
        hasUsedConfigFile = true;
        try {
            String content = Region.getContentFromConfigFile(REGIONS_CONFIG_FILE_PATH);
            if (content == null || content.isEmpty()) {
                return;
            }
            RegionSchema[] regionSchemas = JsonConverter.jsonBlobToObject(content, RegionSchema[].class);
            if (regionSchemas != null && regionSchemas.length != 0) {
                for (RegionSchema regionSchema : regionSchemas) {
                    if (regionSchema == null || !RegionSchema.isValid(regionSchema)) continue;
                    Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception in reading or parsing {} to fetch regions ", (Object)Paths.get(FileUtils.expandUserHome(REGIONS_CONFIG_FILE_PATH), new String[0]), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAlloyRegionConfigFile() {
        hasUsedAlloyConfigFile = true;
        try {
            String content = Region.getContentFromConfigFile(Alloy.getAlloyConfigFilePath());
            if (content == null || content.isEmpty()) {
                return;
            }
            RegionAlloySchema regionAlloySchema = JsonConverter.jsonBlobToObject(content, RegionAlloySchema.class);
            List<RegionSchema> regionSchemas = regionAlloySchema.getRegions();
            if (regionSchemas != null && regionSchemas.size() != 0) {
                for (RegionSchema regionSchema : regionSchemas) {
                    if (regionSchema == null || !RegionSchema.isValid(regionSchema)) continue;
                    Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent(), true), regionSchema.getRegionKey(), true);
                }
            }
            if (regionAlloySchema.getProvider() != null) {
                OCI_ALLOY_CONFIG_PROVIDER = regionAlloySchema.getProvider();
            }
            if (regionAlloySchema.getOciRegionCoexist() != null) {
                IS_ALLOY_REGION_COEXIST_ENABLED = StringUtils.equalsIgnoreCase(regionAlloySchema.getOciRegionCoexist(), "true");
                LOG.info("ociRegionCoexist is set to '{}' in the Alloy configuration file {}", (Object)IS_ALLOY_REGION_COEXIST_ENABLED, (Object)Paths.get(FileUtils.expandUserHome(Alloy.getAlloyConfigFilePath()), new String[0]));
            }
            writeLock.lock();
            try {
                OCI_SDK_ENABLED_SERVICES_SET.addAll(regionAlloySchema.getServices().stream().map(str -> str.toLowerCase()).map(str -> str.replaceAll("[^a-z]", "")).collect(Collectors.toSet()));
            }
            finally {
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception in reading or parsing {} to fetch config from the Alloy configuration file ", (Object)Paths.get(FileUtils.expandUserHome(Alloy.getAlloyConfigFilePath()), new String[0]), (Object)e);
        }
    }

    private static String getContentFromConfigFile(String regionsConfigFilePath) {
        try {
            File file = new File(FileUtils.expandUserHome(regionsConfigFilePath));
            if (!file.isFile()) {
                LOG.info("Config file not found to fetch regions at {} ", (Object)Paths.get(FileUtils.expandUserHome(regionsConfigFilePath), new String[0]));
                return null;
            }
            String content = new String(Files.readAllBytes(Paths.get(FileUtils.expandUserHome(regionsConfigFilePath), new String[0])), StandardCharsets.UTF_8);
            LOG.debug("Region schemas from {} are {}", (Object)regionsConfigFilePath, (Object)content);
            return content;
        }
        catch (Exception e) {
            LOG.warn("Exception in reading or parsing {} to fetch config from the configuration file ", (Object)Paths.get(FileUtils.expandUserHome(regionsConfigFilePath), new String[0]), (Object)e);
            return null;
        }
    }

    public static void enableInstanceMetadataService() {
        hasOptedForInstanceMetadataService = true;
    }

    public static void skipInstanceMetadataService() {
        hasUsedInstanceMetadataService = true;
        hasOptedForInstanceMetadataService = false;
    }

    public static boolean registerFromInstanceMetadataService() {
        if (hasUsedInstanceMetadataService) {
            return hasReceivedInstanceMetadataServiceResponse;
        }
        try {
            writeLock.lock();
            if (hasUsedInstanceMetadataService) {
                boolean bl = hasReceivedInstanceMetadataServiceResponse;
                return bl;
            }
            Region.enableInstanceMetadataService();
            Region result = Region.getRegionFromImds("http://169.254.169.254/opc/v2/");
            if (result != null) {
                regionFromImds = result;
            }
            hasReceivedInstanceMetadataServiceResponse = true;
        }
        catch (RuntimeException e) {
            LOG.warn("Rest call to get regionInfo from metadata service failed ", (Throwable)e);
        }
        finally {
            writeLock.unlock();
            hasUsedInstanceMetadataService = true;
        }
        return hasReceivedInstanceMetadataServiceResponse;
    }

    public static boolean isServiceEnabled(String serviceName) {
        writeLock.lock();
        try {
            if (!hasUsedAlloyConfigFile && Alloy.doesAlloyConfigExist() && OCI_SDK_ENABLED_SERVICES_SET.isEmpty()) {
                Region.readAlloyRegionConfigFile();
            }
            if (OCI_SDK_ENABLED_SERVICES_SET.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = OCI_SDK_ENABLED_SERVICES_SET.contains(serviceName.toLowerCase());
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @InternalSdk
    @VisibleForTesting
    static void resetAlloyConfiguration() {
        writeLock.lock();
        try {
            ALL_REGIONS.keySet().removeIf(key -> ALLOY_REGIONS.containsKey(key) && !KNOWN_REGIONS.containsKey(key));
            ALLOY_REGIONS.clear();
            Realm.clearAlloyRealms();
            hasUsedAlloyConfigFile = false;
            OCI_SDK_ENABLED_SERVICES_SET.clear();
            hasUsedEnvVar = false;
            IS_ALLOY_REGION_COEXIST_ENABLED = false;
            Alloy.resetAlloyRegionCoexistStatus();
        }
        finally {
            writeLock.unlock();
        }
    }

    @InternalSdk
    @VisibleForTesting
    public static Region getRegionFromImds(String metadataServiceBaseUrl) {
        RegionSchema regionSchema;
        LOG.info("Requesting region metadata blob from IMDS at {}", (Object)(metadataServiceBaseUrl + "instance/regionInfo"));
        String regionMetadataSchema = null;
        Throwable lastException = null;
        try (HttpClient client = HttpProvider.getDefault().newBuilder().property(StandardClientProperties.ASYNC_POOL_SIZE, (Object)1).property(StandardClientProperties.READ_TIMEOUT, (Object)Duration.ofSeconds(60L)).property(StandardClientProperties.CONNECT_TIMEOUT, (Object)Duration.ofSeconds(30L)).baseUri(URI.create(metadataServiceBaseUrl + "instance/")).build();){
            ExponentialBackoffDelayStrategyWithJitter strategy = new ExponentialBackoffDelayStrategyWithJitter(TimeUnit.SECONDS.toMillis(100L));
            WaiterConfiguration.WaitContext context = new WaiterConfiguration.WaitContext(System.currentTimeMillis());
            for (int retry = 0; retry < 8; ++retry) {
                try {
                    SyncFutureWaiter waiter = new SyncFutureWaiter();
                    try (HttpResponse response = (HttpResponse)waiter.listenForResult(client.createRequest(Method.GET).offloadExecutor((Executor)waiter).appendPathPart("regionInfo").header("Accept", "application/json").header("Authorization", "Bearer Oracle").execute());){
                        if (response.status() >= 300) {
                            throw new IOException("Bad response status code " + response.status());
                        }
                        regionMetadataSchema = (String)waiter.listenForResult(response.textBody());
                        break;
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Attempt {} - Rest call to get region info from metadata service failed ", (Object)(retry + 1), (Object)e);
                    lastException = e;
                    try {
                        long waitTime = strategy.nextDelay(context);
                        Thread.sleep(waitTime);
                        context.incrementAttempts();
                        LOG.info("Exiting retry {} with wait time: {} millis", (Object)(retry + 1), (Object)waitTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.debug("Thread interrupted while waiting to make next call to get region info from instance metadata service", (Throwable)interruptedException);
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
        if (regionMetadataSchema == null && lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new RuntimeException(lastException);
        }
        LOG.info("Region metadata blob from regionInfo service is {}", regionMetadataSchema);
        if (regionMetadataSchema != null && !regionMetadataSchema.isEmpty() && (regionSchema = JsonConverter.jsonBlobToObject(regionMetadataSchema, RegionSchema.class)) != null && RegionSchema.isValid(regionSchema)) {
            return Region.register(regionSchema.getRegionIdentifier(), Realm.register(regionSchema.getRealmKey(), regionSchema.getRealmDomainComponent()), regionSchema.getRegionKey());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region other = (Region)o;
        String this$regionId = this.regionId;
        String other$regionId = other.regionId;
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        Realm this$realm = this.realm;
        Realm other$realm = other.realm;
        return !(this$realm == null ? other$realm != null : !((Object)this$realm).equals(other$realm));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regionId = this.regionId;
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        Realm $realm = this.realm;
        result = result * 59 + ($realm == null ? 43 : ((Object)$realm).hashCode());
        return result;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public static boolean isAlloyRegionCoexistEnabled() {
        return IS_ALLOY_REGION_COEXIST_ENABLED;
    }

    static {
        IS_ALLOY_REGION_COEXIST_ENABLED = false;
        KNOWN_REGIONS = new LinkedHashMap<String, Region>();
        ALLOY_REGIONS = new LinkedHashMap<String, Region>();
        ALL_REGIONS = new LinkedHashMap<String, Region>();
        LOG = LoggerFactory.getLogger(Region.class);
        hasUsedEnvVar = false;
        hasUsedConfigFile = false;
        hasUsedAlloyConfigFile = false;
        lock = new ReentrantReadWriteLock();
        readLock = lock.readLock();
        writeLock = lock.writeLock();
        hasUsedInstanceMetadataService = false;
        hasOptedForInstanceMetadataService = false;
        hasReceivedInstanceMetadataServiceResponse = false;
        hasWarnedAboutValuesWithoutInstanceMetadataService = false;
        defaultRealmEnvVar = Region.getDefaultRealmFromEnv();
        regionFromImds = null;
        AP_CHUNCHEON_1 = Region.register("ap-chuncheon-1", Realm.OC1, "yny");
        AP_MELBOURNE_1 = Region.register("ap-melbourne-1", Realm.OC1, "mel");
        AP_HYDERABAD_1 = Region.register("ap-hyderabad-1", Realm.OC1, "hyd");
        AP_MUMBAI_1 = Region.register("ap-mumbai-1", Realm.OC1, "bom");
        AP_OSAKA_1 = Region.register("ap-osaka-1", Realm.OC1, "kix");
        AP_SEOUL_1 = Region.register("ap-seoul-1", Realm.OC1, "icn");
        AP_SYDNEY_1 = Region.register("ap-sydney-1", Realm.OC1, "syd");
        AP_TOKYO_1 = Region.register("ap-tokyo-1", Realm.OC1, "nrt");
        CA_MONTREAL_1 = Region.register("ca-montreal-1", Realm.OC1, "yul");
        CA_TORONTO_1 = Region.register("ca-toronto-1", Realm.OC1, "yyz");
        EU_AMSTERDAM_1 = Region.register("eu-amsterdam-1", Realm.OC1, "ams");
        EU_FRANKFURT_1 = Region.register("eu-frankfurt-1", Realm.OC1, "fra");
        EU_ZURICH_1 = Region.register("eu-zurich-1", Realm.OC1, "zrh");
        ME_JEDDAH_1 = Region.register("me-jeddah-1", Realm.OC1, "jed");
        ME_DUBAI_1 = Region.register("me-dubai-1", Realm.OC1, "dxb");
        SA_SAOPAULO_1 = Region.register("sa-saopaulo-1", Realm.OC1, "gru");
        UK_LONDON_1 = Region.register("uk-london-1", Realm.OC1, "lhr");
        US_ASHBURN_1 = Region.register("us-ashburn-1", Realm.OC1, "iad");
        US_PHOENIX_1 = Region.register("us-phoenix-1", Realm.OC1, "phx");
        US_SANJOSE_1 = Region.register("us-sanjose-1", Realm.OC1, "sjc");
        UK_CARDIFF_1 = Region.register("uk-cardiff-1", Realm.OC1, "cwl");
        SA_SANTIAGO_1 = Region.register("sa-santiago-1", Realm.OC1, "scl");
        SA_VINHEDO_1 = Region.register("sa-vinhedo-1", Realm.OC1, "vcp");
        IL_JERUSALEM_1 = Region.register("il-jerusalem-1", Realm.OC1, "mtz");
        EU_MARSEILLE_1 = Region.register("eu-marseille-1", Realm.OC1, "mrs");
        AP_SINGAPORE_1 = Region.register("ap-singapore-1", Realm.OC1, "sin");
        ME_ABUDHABI_1 = Region.register("me-abudhabi-1", Realm.OC1, "auh");
        EU_MILAN_1 = Region.register("eu-milan-1", Realm.OC1, "lin");
        EU_STOCKHOLM_1 = Region.register("eu-stockholm-1", Realm.OC1, "arn");
        AF_JOHANNESBURG_1 = Region.register("af-johannesburg-1", Realm.OC1, "jnb");
        EU_PARIS_1 = Region.register("eu-paris-1", Realm.OC1, "cdg");
        MX_QUERETARO_1 = Region.register("mx-queretaro-1", Realm.OC1, "qro");
        EU_MADRID_1 = Region.register("eu-madrid-1", Realm.OC1, "mad");
        US_CHICAGO_1 = Region.register("us-chicago-1", Realm.OC1, "ord");
        MX_MONTERREY_1 = Region.register("mx-monterrey-1", Realm.OC1, "mty");
        US_SALTLAKE_2 = Region.register("us-saltlake-2", Realm.OC1, "aga");
        SA_BOGOTA_1 = Region.register("sa-bogota-1", Realm.OC1, "bog");
        SA_VALPARAISO_1 = Region.register("sa-valparaiso-1", Realm.OC1, "vap");
        AP_SINGAPORE_2 = Region.register("ap-singapore-2", Realm.OC1, "xsp");
        US_LANGLEY_1 = Region.register("us-langley-1", Realm.OC2, "lfi");
        US_LUKE_1 = Region.register("us-luke-1", Realm.OC2, "luf");
        US_GOV_ASHBURN_1 = Region.register("us-gov-ashburn-1", Realm.OC3, "ric");
        US_GOV_CHICAGO_1 = Region.register("us-gov-chicago-1", Realm.OC3, "pia");
        US_GOV_PHOENIX_1 = Region.register("us-gov-phoenix-1", Realm.OC3, "tus");
        UK_GOV_LONDON_1 = Region.register("uk-gov-london-1", Realm.OC4, "ltn");
        UK_GOV_CARDIFF_1 = Region.register("uk-gov-cardiff-1", Realm.OC4, "brs");
        AP_CHIYODA_1 = Region.register("ap-chiyoda-1", Realm.OC8, "nja");
        AP_IBARAKI_1 = Region.register("ap-ibaraki-1", Realm.OC8, "ukb");
        ME_DCC_MUSCAT_1 = Region.register("me-dcc-muscat-1", Realm.OC9, "mct");
        AP_DCC_CANBERRA_1 = Region.register("ap-dcc-canberra-1", Realm.OC10, "wga");
        EU_DCC_MILAN_1 = Region.register("eu-dcc-milan-1", Realm.OC14, "bgy");
        EU_DCC_MILAN_2 = Region.register("eu-dcc-milan-2", Realm.OC14, "mxp");
        EU_DCC_DUBLIN_2 = Region.register("eu-dcc-dublin-2", Realm.OC14, "snn");
        EU_DCC_RATING_2 = Region.register("eu-dcc-rating-2", Realm.OC14, "dtm");
        EU_DCC_RATING_1 = Region.register("eu-dcc-rating-1", Realm.OC14, "dus");
        EU_DCC_DUBLIN_1 = Region.register("eu-dcc-dublin-1", Realm.OC14, "ork");
        EU_JOVANOVAC_1 = Region.register("eu-jovanovac-1", Realm.OC20, "beg");
        EU_MADRID_2 = Region.register("eu-madrid-2", Realm.OC19, "vll");
        EU_FRANKFURT_2 = Region.register("eu-frankfurt-2", Realm.OC19, "str");
        EU_DCC_ZURICH_1 = Region.register("eu-dcc-zurich-1", Realm.OC24, "avz");
        ME_DCC_DOHA_1 = Region.register("me-dcc-doha-1", Realm.OC21, "doh");
        ME_ABUDHABI_3 = Region.register("me-abudhabi-3", Realm.OC26, "ahu");
        AP_DCC_GAZIPUR_1 = Region.register("ap-dcc-gazipur-1", Realm.OC15, "dac");
        ME_ABUDHABI_2 = Region.register("me-abudhabi-2", Realm.OC29, "rkt");
        SERVICE_TO_REGION_ENDPOINTS = new HashMap<String, Map<Region, String>>();
        OCI_SDK_ENABLED_SERVICES_SET = new HashSet<String>();
    }
}

