/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AbstractFederationClient;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.GetResourcePrincipalTokenResponse;
import com.oracle.bmc.auth.internal.KeyPairAuthenticationDetailProvider;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePrincipalV2FederationClient
extends AbstractFederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalV2FederationClient.class);
    private final KeyPairAuthenticationDetailProvider provider;

    public ResourcePrincipalV2FederationClient(String resourcePrincipalTokenEndpoint, String federationEndpoint, SessionKeySupplier sessionKeySupplier, KeyPairAuthenticationDetailProvider keyPairAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        super(resourcePrincipalTokenEndpoint, federationEndpoint, sessionKeySupplier, keyPairAuthenticationDetailsProvider, clientConfigurator, circuitBreakerConfiguration);
        this.provider = keyPairAuthenticationDetailsProvider;
    }

    @Override
    protected SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        GetResourcePrincipalTokenResponse getResourcePrincipalTokenResponse = this.prepareRptCall().method((Method)Method.GET).logger((Logger)ResourcePrincipalV2FederationClient.LOG, (String)"ResourcePrincipalsV2FederationClient").appendPathPart((String)"20180711").appendPathPart((String)"resourcePrincipalTokenV2").appendPathPart((String)this.provider.refresh()).callSync().body;
        String servicePrincipalSessionToken = getResourcePrincipalTokenResponse.getServicePrincipalSessionToken();
        String resourcePrincipalToken = getResourcePrincipalTokenResponse.getResourcePrincipalToken();
        return this.requestSessionToken(new GetResourcePrincipalSessionTokenRequest(resourcePrincipalToken, servicePrincipalSessionToken, AuthUtils.base64EncodeNoChunking(publicKey)));
    }
}

