/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.AsyncHandler;
import java.beans.ConstructorProperties;

public abstract class RefreshAuthTokenWrappingAsyncHandler<REQUEST, RESPONSE>
implements AsyncHandler<REQUEST, RESPONSE> {
    private static final int NUM_TRIES_ALLOWED = 2;
    private final RefreshableOnNotAuthenticatedProvider<?> authDetailsProvider;
    private final AsyncHandler<REQUEST, RESPONSE> innerHandler;
    private int currentAttempt = 0;

    @Override
    public void onSuccess(REQUEST request, RESPONSE response) {
        this.innerHandler.onSuccess(request, response);
    }

    @Override
    public void onError(REQUEST request, Throwable error) {
        ++this.currentAttempt;
        if (error instanceof BmcException) {
            if (((BmcException)error).getStatusCode() == 401 && this.currentAttempt < 2) {
                this.authDetailsProvider.refresh();
                this.retryCall();
            } else {
                this.innerHandler.onError(request, error);
            }
        } else {
            this.innerHandler.onError(request, error);
        }
    }

    public abstract void retryCall();

    @ConstructorProperties(value={"authDetailsProvider", "innerHandler"})
    public RefreshAuthTokenWrappingAsyncHandler(RefreshableOnNotAuthenticatedProvider<?> authDetailsProvider, AsyncHandler<REQUEST, RESPONSE> innerHandler) {
        this.authDetailsProvider = authDetailsProvider;
        this.innerHandler = innerHandler;
    }
}

