/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.model.BmcException;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;

public class RefreshAuthTokenTransformingFuture<FROM, TO>
implements Future<TO> {
    @NonNull
    private Future<FROM> delegate;
    private final Function<FROM, TO> transformer;
    private final RefreshableOnNotAuthenticatedProvider<?> authProvider;
    private final Supplier<Future<FROM>> generateNewFutureForRetry;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public TO get() throws InterruptedException, ExecutionException {
        FROM from = this.delegate.get();
        try {
            return (TO)this.transformer.apply(from);
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.authProvider.refresh();
                this.delegate = (Future)this.generateNewFutureForRetry.get();
                return (TO)this.transformer.apply(this.delegate.get());
            }
            throw e;
        }
    }

    @Override
    public TO get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FROM from = this.delegate.get(timeout, unit);
        try {
            return (TO)this.transformer.apply(from);
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.authProvider.refresh();
                this.delegate = (Future)this.generateNewFutureForRetry.get();
                return (TO)this.transformer.apply(this.delegate.get(timeout, unit));
            }
            throw e;
        }
    }

    @ConstructorProperties(value={"delegate", "transformer", "authProvider", "generateNewFutureForRetry"})
    public RefreshAuthTokenTransformingFuture(@NonNull Future<FROM> delegate, Function<FROM, TO> transformer, RefreshableOnNotAuthenticatedProvider<?> authProvider, Supplier<Future<FROM>> generateNewFutureForRetry) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked @NonNull but is null");
        }
        this.delegate = delegate;
        this.transformer = transformer;
        this.authProvider = authProvider;
        this.generateNewFutureForRetry = generateNewFutureForRetry;
    }
}

