/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.retrier.Retriers;
import java.util.UUID;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=3000)
public class RetryTokenFilter
implements ClientRequestFilter {
    private static final String OPC_RETRY_TOKEN_HEADER = "opc-retry-token";

    private static String generateRetryToken() {
        return UUID.randomUUID().toString();
    }

    public void filter(ClientRequestContext requestContext) {
        if (!Retriers.shouldSendOpcRetryToken()) {
            return;
        }
        boolean isOpcRetryTokenAlreadySet = HeaderUtils.get((MultivaluedMap<String, String>)requestContext.getStringHeaders(), OPC_RETRY_TOKEN_HEADER).isPresent();
        if (isOpcRetryTokenAlreadySet) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("POST")) {
            requestContext.getHeaders().putSingle((Object)OPC_RETRY_TOKEN_HEADER, (Object)RetryTokenFilter.generateRetryToken());
        }
    }
}

