/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.MetricTimeWindow;
import com.oracle.bmc.cloudmigrations.model.MetricType;
import com.oracle.bmc.cloudmigrations.model.ResourceAssessmentStrategy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="strategyType")
@JsonFilter(value="explicitlySetFilter")
public final class PeakResourceAssessmentStrategy
extends ResourceAssessmentStrategy {
    @JsonProperty(value="adjustmentMultiplier")
    private final Float adjustmentMultiplier;
    @JsonProperty(value="metricType")
    private final MetricType metricType;
    @JsonProperty(value="metricTimeWindow")
    private final MetricTimeWindow metricTimeWindow;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PeakResourceAssessmentStrategy(ResourceAssessmentStrategy.ResourceType resourceType, Float adjustmentMultiplier, MetricType metricType, MetricTimeWindow metricTimeWindow) {
        super(resourceType);
        this.adjustmentMultiplier = adjustmentMultiplier;
        this.metricType = metricType;
        this.metricTimeWindow = metricTimeWindow;
    }

    public Float getAdjustmentMultiplier() {
        return this.adjustmentMultiplier;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public MetricTimeWindow getMetricTimeWindow() {
        return this.metricTimeWindow;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PeakResourceAssessmentStrategy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", adjustmentMultiplier=").append(String.valueOf(this.adjustmentMultiplier));
        sb.append(", metricType=").append(String.valueOf((Object)this.metricType));
        sb.append(", metricTimeWindow=").append(String.valueOf((Object)this.metricTimeWindow));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeakResourceAssessmentStrategy)) {
            return false;
        }
        PeakResourceAssessmentStrategy other = (PeakResourceAssessmentStrategy)((Object)o);
        return Objects.equals(this.adjustmentMultiplier, other.adjustmentMultiplier) && Objects.equals((Object)this.metricType, (Object)other.metricType) && Objects.equals((Object)this.metricTimeWindow, (Object)other.metricTimeWindow) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.adjustmentMultiplier == null ? 43 : this.adjustmentMultiplier.hashCode());
        result = result * 59 + (this.metricType == null ? 43 : this.metricType.hashCode());
        result = result * 59 + (this.metricTimeWindow == null ? 43 : this.metricTimeWindow.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private ResourceAssessmentStrategy.ResourceType resourceType;
        @JsonProperty(value="adjustmentMultiplier")
        private Float adjustmentMultiplier;
        @JsonProperty(value="metricType")
        private MetricType metricType;
        @JsonProperty(value="metricTimeWindow")
        private MetricTimeWindow metricTimeWindow;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(ResourceAssessmentStrategy.ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder adjustmentMultiplier(Float adjustmentMultiplier) {
            this.adjustmentMultiplier = adjustmentMultiplier;
            this.__explicitlySet__.add("adjustmentMultiplier");
            return this;
        }

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            this.__explicitlySet__.add("metricType");
            return this;
        }

        public Builder metricTimeWindow(MetricTimeWindow metricTimeWindow) {
            this.metricTimeWindow = metricTimeWindow;
            this.__explicitlySet__.add("metricTimeWindow");
            return this;
        }

        public PeakResourceAssessmentStrategy build() {
            PeakResourceAssessmentStrategy model = new PeakResourceAssessmentStrategy(this.resourceType, this.adjustmentMultiplier, this.metricType, this.metricTimeWindow);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PeakResourceAssessmentStrategy model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("adjustmentMultiplier")) {
                this.adjustmentMultiplier(model.getAdjustmentMultiplier());
            }
            if (model.wasPropertyExplicitlySet("metricType")) {
                this.metricType(model.getMetricType());
            }
            if (model.wasPropertyExplicitlySet("metricTimeWindow")) {
                this.metricTimeWindow(model.getMetricTimeWindow());
            }
            return this;
        }
    }
}

