/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations;

import com.oracle.bmc.cloudmigrations.Migration;
import com.oracle.bmc.cloudmigrations.model.Migration;
import com.oracle.bmc.cloudmigrations.model.MigrationAsset;
import com.oracle.bmc.cloudmigrations.model.MigrationPlan;
import com.oracle.bmc.cloudmigrations.model.ReplicationSchedule;
import com.oracle.bmc.cloudmigrations.model.TargetAsset;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.GetReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.GetTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.GetReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.GetTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class MigrationWaiters {
    private final ExecutorService executorService;
    private final Migration client;

    public MigrationWaiters(ExecutorService executorService, Migration client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, Migration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, Migration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Migration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(BmcGenericWaiter waiter, GetMigrationRequest request, Migration.LifecycleState ... targetStates) {
        final HashSet<Migration.LifecycleState> targetStatesSet = new HashSet<Migration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMigrationRequest, GetMigrationResponse>(){

            @Override
            public GetMigrationResponse apply(GetMigrationRequest request) {
                return MigrationWaiters.this.client.getMigration(request);
            }
        }, (Predicate)new Predicate<GetMigrationResponse>(){

            @Override
            public boolean test(GetMigrationResponse response) {
                return targetStatesSet.contains((Object)response.getMigration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Migration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMigrationAssetRequest, GetMigrationAssetResponse> forMigrationAsset(GetMigrationAssetRequest request, MigrationAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigrationAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMigrationAssetRequest, GetMigrationAssetResponse> forMigrationAsset(GetMigrationAssetRequest request, MigrationAsset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMigrationAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMigrationAssetRequest, GetMigrationAssetResponse> forMigrationAsset(GetMigrationAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MigrationAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMigrationAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMigrationAssetRequest, GetMigrationAssetResponse> forMigrationAsset(BmcGenericWaiter waiter, GetMigrationAssetRequest request, MigrationAsset.LifecycleState ... targetStates) {
        final HashSet<MigrationAsset.LifecycleState> targetStatesSet = new HashSet<MigrationAsset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMigrationAssetRequest, GetMigrationAssetResponse>(){

            @Override
            public GetMigrationAssetResponse apply(GetMigrationAssetRequest request) {
                return MigrationWaiters.this.client.getMigrationAsset(request);
            }
        }, (Predicate)new Predicate<GetMigrationAssetResponse>(){

            @Override
            public boolean test(GetMigrationAssetResponse response) {
                return targetStatesSet.contains((Object)response.getMigrationAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MigrationAsset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMigrationPlanRequest, GetMigrationPlanResponse> forMigrationPlan(GetMigrationPlanRequest request, MigrationPlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigrationPlan(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMigrationPlanRequest, GetMigrationPlanResponse> forMigrationPlan(GetMigrationPlanRequest request, MigrationPlan.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMigrationPlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMigrationPlanRequest, GetMigrationPlanResponse> forMigrationPlan(GetMigrationPlanRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MigrationPlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMigrationPlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMigrationPlanRequest, GetMigrationPlanResponse> forMigrationPlan(BmcGenericWaiter waiter, GetMigrationPlanRequest request, MigrationPlan.LifecycleState ... targetStates) {
        final HashSet<MigrationPlan.LifecycleState> targetStatesSet = new HashSet<MigrationPlan.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMigrationPlanRequest, GetMigrationPlanResponse>(){

            @Override
            public GetMigrationPlanResponse apply(GetMigrationPlanRequest request) {
                return MigrationWaiters.this.client.getMigrationPlan(request);
            }
        }, (Predicate)new Predicate<GetMigrationPlanResponse>(){

            @Override
            public boolean test(GetMigrationPlanResponse response) {
                return targetStatesSet.contains((Object)response.getMigrationPlan().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MigrationPlan.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetReplicationScheduleRequest, GetReplicationScheduleResponse> forReplicationSchedule(GetReplicationScheduleRequest request, ReplicationSchedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReplicationSchedule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetReplicationScheduleRequest, GetReplicationScheduleResponse> forReplicationSchedule(GetReplicationScheduleRequest request, ReplicationSchedule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forReplicationSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetReplicationScheduleRequest, GetReplicationScheduleResponse> forReplicationSchedule(GetReplicationScheduleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ReplicationSchedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forReplicationSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetReplicationScheduleRequest, GetReplicationScheduleResponse> forReplicationSchedule(BmcGenericWaiter waiter, GetReplicationScheduleRequest request, ReplicationSchedule.LifecycleState ... targetStates) {
        final HashSet<ReplicationSchedule.LifecycleState> targetStatesSet = new HashSet<ReplicationSchedule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetReplicationScheduleRequest, GetReplicationScheduleResponse>(){

            @Override
            public GetReplicationScheduleResponse apply(GetReplicationScheduleRequest request) {
                return MigrationWaiters.this.client.getReplicationSchedule(request);
            }
        }, (Predicate)new Predicate<GetReplicationScheduleResponse>(){

            @Override
            public boolean test(GetReplicationScheduleResponse response) {
                return targetStatesSet.contains((Object)response.getReplicationSchedule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ReplicationSchedule.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetAssetRequest, GetTargetAssetResponse> forTargetAsset(GetTargetAssetRequest request, TargetAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetAssetRequest, GetTargetAssetResponse> forTargetAsset(GetTargetAssetRequest request, TargetAsset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetAssetRequest, GetTargetAssetResponse> forTargetAsset(GetTargetAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TargetAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTargetAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetAssetRequest, GetTargetAssetResponse> forTargetAsset(BmcGenericWaiter waiter, GetTargetAssetRequest request, TargetAsset.LifecycleState ... targetStates) {
        final HashSet<TargetAsset.LifecycleState> targetStatesSet = new HashSet<TargetAsset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetAssetRequest, GetTargetAssetResponse>(){

            @Override
            public GetTargetAssetResponse apply(GetTargetAssetRequest request) {
                return MigrationWaiters.this.client.getTargetAsset(request);
            }
        }, (Predicate)new Predicate<GetTargetAssetResponse>(){

            @Override
            public boolean test(GetTargetAssetResponse response) {
                return targetStatesSet.contains((Object)response.getTargetAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TargetAsset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return MigrationWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

