/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.AddCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AddCompartmentRequest
extends BmcRequest<AddCompartmentDetails> {
    private String securityZoneId;
    private AddCompartmentDetails addCompartmentDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getSecurityZoneId() {
        return this.securityZoneId;
    }

    public AddCompartmentDetails getAddCompartmentDetails() {
        return this.addCompartmentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public AddCompartmentDetails getBody$() {
        return this.addCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().securityZoneId(this.securityZoneId).addCompartmentDetails(this.addCompartmentDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityZoneId=").append(String.valueOf(this.securityZoneId));
        sb.append(",addCompartmentDetails=").append(String.valueOf((Object)this.addCompartmentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddCompartmentRequest)) {
            return false;
        }
        AddCompartmentRequest other = (AddCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityZoneId, other.securityZoneId) && Objects.equals((Object)this.addCompartmentDetails, (Object)other.addCompartmentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityZoneId == null ? 43 : this.securityZoneId.hashCode());
        result = result * 59 + (this.addCompartmentDetails == null ? 43 : this.addCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AddCompartmentRequest, AddCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityZoneId = null;
        private AddCompartmentDetails addCompartmentDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder securityZoneId(String securityZoneId) {
            this.securityZoneId = securityZoneId;
            return this;
        }

        public Builder addCompartmentDetails(AddCompartmentDetails addCompartmentDetails) {
            this.addCompartmentDetails = addCompartmentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AddCompartmentRequest o) {
            this.securityZoneId(o.getSecurityZoneId());
            this.addCompartmentDetails(o.getAddCompartmentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AddCompartmentRequest build() {
            AddCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AddCompartmentDetails body) {
            this.addCompartmentDetails(body);
            return this;
        }

        public AddCompartmentRequest buildWithoutInvocationCallback() {
            AddCompartmentRequest request = new AddCompartmentRequest();
            request.securityZoneId = this.securityZoneId;
            request.addCompartmentDetails = this.addCompartmentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

